/*
 * Decompiled with CFR 0.152.
 */
package netzwerk.dialog;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import netzwerk.dialog.TextFieldLimiter;
import netzwerkkarte.NetworkField;
import nodehandler.AbkKatalog;
import nodehandler.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditNodeDlg
extends JDialog {
    private boolean ok;
    private boolean delete = false;
    private boolean KanteTwo = true;
    private boolean PARTNER = false;
    private Position pos;
    private String[] abkkat = new String[0];
    private NetworkField nfield;
    private ButtonGroup buttonGroup1;
    private JButton jBAbbrechen;
    private JButton jBDelete;
    private JButton jBOK;
    private JComboBox jCBAnonZeichen;
    private JCheckBox jCBMaennlich;
    private JCheckBox jCBPartner;
    private JCheckBox jCBWeiblich;
    private JComboBox jComboBox1;
    private JLabel jLAnonZeichen;
    private JLabel jLKante;
    private JLabel jLName;
    private JLabel jLNotiz;
    private JLabel jLPartner;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTANotiz;
    private JTextField jTFName;

    public EditNodeDlg(Frame parent, boolean modal, Position pos, boolean KanteTwo) {
        super(parent, modal);
        this.nfield = (NetworkField)parent;
        this.pos = pos;
        this.KanteTwo = KanteTwo;
        this.initComponents();
        this.jTFName.setText(pos.getN().getName());
        this.jComboBox1.setSelectedIndex(pos.getKante());
        if (pos.getDistanz() <= 0) {
            this.jComboBox1.setSelectedIndex(0);
            this.jComboBox1.setEnabled(false);
        }
        if (pos.getN().isMaennlich()) {
            this.setMaennlich(true);
        } else {
            this.setWeiblich(true);
        }
        this.setCBAnonymZeichen(pos.getNmhandler().getAbkkat());
        if (pos.getN().getName().isEmpty()) {
            System.out.println("Name is empty - assuming new node and assigning to sector");
            if (pos.getPosX() < 0.5) {
                if (pos.getPosY() < 0.5) {
                    this.jCBAnonZeichen.setSelectedIndex(2);
                } else {
                    this.jCBAnonZeichen.setSelectedIndex(3);
                }
            } else if (pos.getPosY() < 0.5) {
                this.jCBAnonZeichen.setSelectedIndex(1);
            } else {
                this.jCBAnonZeichen.setSelectedIndex(4);
            }
        }
        this.jTANotiz.setDocument(new TextFieldLimiter(200));
        this.jTANotiz.setText(pos.getN().getNotiz());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.jLName = new JLabel();
        this.jTFName = new JTextField();
        this.jLKante = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jCBMaennlich = new JCheckBox();
        this.jCBWeiblich = new JCheckBox();
        this.jLAnonZeichen = new JLabel();
        this.jCBAnonZeichen = new JComboBox();
        this.jLPartner = new JLabel();
        this.jCBPartner = new JCheckBox();
        this.jLNotiz = new JLabel();
        this.jPanel1 = new JPanel();
        this.jBDelete = new JButton();
        this.jBAbbrechen = new JButton();
        this.jBOK = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTANotiz = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.nfield.getTranslation("dialogEditNodeTitle"));
        this.jPanel2.setLayout(new GridLayout(0, 2));
        this.jLName.setText(this.nfield.getTranslation("dialogEditNodeName"));
        this.jPanel2.add(this.jLName);
        this.jTFName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                EditNodeDlg.this.jTFNameKeyPressed(evt);
            }
        });
        this.jPanel2.add(this.jTFName);
        this.jLKante.setText(this.nfield.getTranslation("dialogEditNodeBond"));
        this.jPanel2.add(this.jLKante);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(this.getCBList()));
        this.jComboBox1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                EditNodeDlg.this.jComboBox1KeyPressed(evt);
            }
        });
        this.jPanel2.add(this.jComboBox1);
        this.buttonGroup1.add(this.jCBMaennlich);
        this.jCBMaennlich.setSelected(true);
        this.jCBMaennlich.setText(this.nfield.getTranslation("dialogEditNodeMale"));
        this.jCBMaennlich.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                EditNodeDlg.this.jCBMaennlichKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                EditNodeDlg.this.jCBMaennlichKeyTyped(evt);
            }
        });
        this.jPanel2.add(this.jCBMaennlich);
        this.buttonGroup1.add(this.jCBWeiblich);
        this.jCBWeiblich.setText(this.nfield.getTranslation("dialogEditNodeFemale"));
        this.jCBWeiblich.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                EditNodeDlg.this.jCBWeiblichKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                EditNodeDlg.this.jCBWeiblichKeyTyped(evt);
            }
        });
        this.jPanel2.add(this.jCBWeiblich);
        this.jLAnonZeichen.setText(this.nfield.getTranslation("dialogEditNodeAnonymeSign"));
        this.jPanel2.add(this.jLAnonZeichen);
        this.jCBAnonZeichen.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                EditNodeDlg.this.jCBAnonZeichenKeyPressed(evt);
            }

            public void keyTyped(KeyEvent evt) {
                EditNodeDlg.this.jCBAnonZeichenKeyTyped(evt);
            }
        });
        this.jPanel2.add(this.jCBAnonZeichen);
        this.jLPartner.setText(this.nfield.getTranslation("dialogEditNodeRelativeOfPartner"));
        this.jPanel2.add(this.jLPartner);
        this.jCBPartner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditNodeDlg.this.jCBPartnerActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jCBPartner);
        this.jLNotiz.setText(this.nfield.getTranslation("dialogEditNodeNote"));
        this.jPanel2.add(this.jLNotiz);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel1.setLayout(new GridLayout(1, 3));
        this.jBDelete.setText(this.nfield.getTranslation("buttonDelete"));
        this.jBDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditNodeDlg.this.jBDeleteActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jBDelete);
        this.jBAbbrechen.setText(this.nfield.getTranslation("buttonCancel"));
        this.jBAbbrechen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditNodeDlg.this.jBAbbrechenActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jBAbbrechen);
        this.jBOK.setText(this.nfield.getTranslation("buttonOK"));
        this.jBOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EditNodeDlg.this.jBOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jBOK);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jTANotiz.setColumns(20);
        this.jTANotiz.setLineWrap(true);
        this.jTANotiz.setRows(5);
        this.jTANotiz.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.jTANotiz);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jBDeleteActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(null, this.nfield.getTranslation("dialogEditNodeConfirmSureDeletePersonText"), this.nfield.getTranslation("dialogEditNodeConfirmSureDeletePersonTitle"), 0, 3) == 0) {
            this.delete = true;
            this.dispose();
        }
    }

    private void jBAbbrechenActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.dispose();
    }

    private void jBOKActionPerformed(ActionEvent evt) {
        if (this.jTFName.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, this.nfield.getTranslation("dialogEditNodeMessagePersonHasNoNameText"), this.nfield.getTranslation("dialogEditNodeMessagePersonHasNoNameTitle"), 0);
            return;
        }
        this.ok = true;
        this.dispose();
    }

    private void jTFNameKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jBOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.jBAbbrechenActionPerformed(null);
        }
    }

    private void jComboBox1KeyPressed(KeyEvent evt) {
        this.jTFNameKeyPressed(evt);
    }

    private void jCBWeiblichKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jBOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.jBAbbrechenActionPerformed(null);
        }
    }

    private void jCBMaennlichKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jBOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.jBAbbrechenActionPerformed(null);
        }
    }

    private void jCBAnonZeichenKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jBOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.jBAbbrechenActionPerformed(null);
        }
    }

    private void jCBAnonZeichenKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jBOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.jBAbbrechenActionPerformed(null);
        }
    }

    private void jCBMaennlichKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jBOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.jBAbbrechenActionPerformed(null);
        }
    }

    private void jCBWeiblichKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jBOKActionPerformed(null);
        }
        if (evt.getKeyCode() == 27) {
            this.jBAbbrechenActionPerformed(null);
        }
    }

    private void jCBPartnerActionPerformed(ActionEvent evt) {
        this.PARTNER = !this.PARTNER;
    }

    public JComboBox getjCBAnonZeichen() {
        return this.jCBAnonZeichen;
    }

    private String[] getCBList() {
        if (this.KanteTwo || this.pos.getKante() == 2) {
            return new String[]{"0", "1", "2"};
        }
        return new String[]{"0", "1"};
    }

    public String getNotiz() {
        try {
            return this.jTANotiz.getDocument().getText(0, this.jTANotiz.getDocument().getLength());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(EditNodeDlg.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    public void setCBAnonymZeichen(List<AbkKatalog> list) {
        this.abkkat = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.abkkat[i] = list.get(i).getAbk() + " - " + list.get(i).getAusdruck();
        }
        this.jCBAnonZeichen.setModel(new DefaultComboBoxModel<String>(this.abkkat));
        String a = this.pos.getN().getAnonAbk();
        this.jCBAnonZeichen.setSelectedIndex(0);
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getAbk().equals(a)) continue;
            this.jCBAnonZeichen.setSelectedIndex(i);
        }
    }

    public String getAnonymZeichen() {
        String retString = "";
        if (this.PARTNER) {
            retString = retString + "P";
        }
        retString = retString + ((String)this.jCBAnonZeichen.getSelectedItem()).split("-")[0].trim();
        return retString;
    }

    public void setNotiz(String text) {
        this.jTANotiz.setText(text);
    }

    public void setNewNode() {
        this.jPanel1.remove(this.jBDelete);
    }

    public void setMaennlich(boolean b) {
        this.jCBMaennlich.setSelected(b);
    }

    public void setWeiblich(boolean b) {
        this.jCBWeiblich.setSelected(b);
    }

    public boolean isMaennlich() {
        return this.jCBMaennlich.isSelected();
    }

    public boolean isWeiblich() {
        return this.jCBWeiblich.isSelected();
    }

    public String getNodeName() {
        return this.jTFName.getText();
    }

    public int getKante() {
        return this.jComboBox1.getSelectedIndex();
    }

    public boolean isOK() {
        return this.ok;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean isPARTNER() {
        return this.PARTNER;
    }

    public void setPARTNER(boolean PARTNER) {
        this.PARTNER = PARTNER;
        if (PARTNER) {
            this.jCBPartner.setSelected(true);
        }
    }
}

