/*
 * Decompiled with CFR 0.152.
 */
package netzwerkkarte;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import netzwerk.dialog.EditNodeDlg;
import netzwerk.dialog.PictureManagerDlg;
import netzwerkkarte.MyLabel;
import netzwerkkarte.NetworkField;
import netzwerkkarte.NodeMetaHandler;
import nodehandler.AbkKatalog;
import nodehandler.Link;
import nodehandler.Node;
import nodehandler.NodeHandler;
import nodehandler.NodeSelectionHandler;
import nodehandler.Position;

public class Field
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private int height;
    private int width;
    private NodeMetaHandler nm_handler;
    private NetworkField netfield;
    private NodeSelectionHandler selNode;
    private boolean STRG_PRESSED = false;
    private boolean SHIFT_PRESSED = false;
    private boolean FIRST_START = true;
    private boolean KOPY_FIELD = false;
    private double selRect_posX1 = -1.0;
    private double selRect_posY1 = -1.0;
    private double selRect_posX2 = -1.0;
    private double selRect_posY2 = -1.0;
    MyLabel jLPicture;
    ImageIcon icon;
    ImageIcon icon_copy;
    double zoom = 1.0;
    private boolean HAS_PICTURE = false;
    private boolean MOVE_PICTURE = false;
    private boolean MOVING_PICTURE = false;
    private boolean SET_CENTER = false;
    private boolean DRAW_CIRCLES = false;
    PictureManagerDlg picMan;
    int pX;
    int pY;
    int orig_pX;
    int orig_pY;
    int center_picX;
    int center_picY;
    int mouse_posX;
    int mouse_posY;
    boolean MOUSE_SAVE_POSITOIN = true;

    public Field(NetworkField parent) {
        this.netfield = parent;
        this.nm_handler = new NodeMetaHandler(this);
        this.setBackground(Color.WHITE);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setFocusable(true);
        this.addKeyListener(this);
        this.selNode = new NodeSelectionHandler(this);
        this.jLPicture = new MyLabel();
        this.jLPicture.setField(this);
        this.jLPicture.setLocation(0, 0);
        this.add(this.jLPicture);
    }

    public void paintComponent(Graphics g) {
        this.height = this.getHeight();
        this.width = this.getWidth();
        this.paint(g, this.width, this.height);
    }

    public void paint(Graphics g, int width, int height) {
        this.netfield.resize();
        if (this.FIRST_START) {
            Color c = g.getColor();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, width, height);
            g.setColor(c);
            return;
        }
        if (this.DRAW_CIRCLES) {
            int width_circle_near = width / 3;
            int height_circle_near = height / 3;
            int width_circle_far = width / 6;
            int height_circle_far = height / 6;
            g.setColor(new Color(239, 239, 239));
            g.fillRect(0, 0, width, height);
            g.setColor(new Color(120, 254, 119));
            g.fillOval(0, 0, width, height);
            g.setColor(Color.WHITE);
            g.drawOval(0, 0, width, height);
            g.fillOval(width_circle_far, height_circle_far, width_circle_far * 4, height_circle_far * 4);
            g.setColor(new Color(120, 254, 119));
            g.fillOval(width_circle_near, height_circle_near, width_circle_near, height_circle_near);
        } else {
            g.setColor(new Color(239, 239, 239));
            g.fillRect(0, 0, width, height);
            g.setColor(Color.WHITE);
            g.fillOval(0, 0, width, height);
            g.setColor(Color.BLACK);
            g.drawOval(0, 0, width, height);
        }
        g.setColor(Color.BLACK);
        g.drawLine(width / 2, 0, width / 2, height);
        g.drawLine(0, height / 2, width, height / 2);
        g.setFont(new Font("SansSerif", 1, 16));
        g.drawString(this.netfield.getTranslation("fieldNameUpLeft"), 5, 20);
        g.drawString(this.netfield.getTranslation("fieldNameUpRight"), width - 70, 20);
        g.drawString(this.netfield.getTranslation("fieldNameDownLeft"), 5, height - 20);
        g.drawString(this.netfield.getTranslation("fieldNameDownRight"), width - 140, height - 20);
        this.nm_handler.draw(g, width, height, this.netfield.isANONYM());
        if (this.KOPY_FIELD) {
            this.netfield.getList_pos().get(this.netfield.getPos_copy_person()).drawMouse(g, this.mouse_posX, this.mouse_posY);
        }
        if (this.selRect_posX1 >= 0.0) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{2.0f}, 0.0f));
            if (this.selRect_posX1 - this.selRect_posX2 < 0.0) {
                if (this.selRect_posY1 - this.selRect_posY2 < 0.0) {
                    g2.drawRect((int)(this.selRect_posX1 * (double)this.getWidth()), (int)(this.selRect_posY1 * (double)this.getHeight()), (int)((this.selRect_posX2 - this.selRect_posX1) * (double)this.getWidth()), (int)((this.selRect_posY2 - this.selRect_posY1) * (double)this.getHeight()));
                } else {
                    g2.drawRect((int)(this.selRect_posX1 * (double)this.getWidth()), (int)(this.selRect_posY2 * (double)this.getHeight()), (int)((this.selRect_posX2 - this.selRect_posX1) * (double)this.getWidth()), (int)((this.selRect_posY1 - this.selRect_posY2) * (double)this.getHeight()));
                }
            } else if (this.selRect_posY1 - this.selRect_posY2 < 0.0) {
                g2.drawRect((int)(this.selRect_posX2 * (double)this.getWidth()), (int)(this.selRect_posY1 * (double)this.getHeight()), (int)((this.selRect_posX1 - this.selRect_posX2) * (double)this.getWidth()), (int)((this.selRect_posY2 - this.selRect_posY1) * (double)this.getHeight()));
            } else {
                g2.drawRect((int)(this.selRect_posX2 * (double)this.getWidth()), (int)(this.selRect_posY2 * (double)this.getHeight()), (int)((this.selRect_posX1 - this.selRect_posX2) * (double)this.getWidth()), (int)((this.selRect_posY1 - this.selRect_posY2) * (double)this.getHeight()));
            }
        }
    }

    public void newField() {
        this.nm_handler = new NodeMetaHandler(this);
    }

    public NodeHandler getNodeHandler() {
        return this.nm_handler.getNodeHandler();
    }

    public void loadPicture(ImageIcon img) {
        this.icon_copy = new ImageIcon(img.getDescription());
        this.icon = img;
        this.jLPicture.setLocation(50, 50);
        this.jLPicture.setIcon(img);
        this.picMan = new PictureManagerDlg((Frame)this.netfield, false, this);
        this.picMan.setVisible(true);
        this.repaint();
    }

    public void deletePicture() {
        this.jLPicture = new MyLabel();
    }

    public void MoveActionPerformed() {
        boolean bl = this.MOVE_PICTURE = !this.MOVE_PICTURE;
        if (this.MOVE_PICTURE) {
            this.orig_pX = this.jLPicture.getLocation().x;
            this.orig_pY = this.jLPicture.getLocation().y;
            this.pY = 0;
            this.pX = 0;
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.FIRST_START) {
            return;
        }
        if (this.KOPY_FIELD) {
            this.mouseClicked_CopyField(e);
            return;
        }
        int posX = e.getX();
        int posY = e.getY();
        Position p = this.nm_handler.intersect((double)posX / (double)this.width, (double)posY / (double)this.height);
        Node n = null;
        if (p != null) {
            n = p.getN();
        }
        if (this.SET_CENTER) {
            this.center_picX = e.getX() - this.jLPicture.getLocation().x;
            this.center_picY = e.getY() - this.jLPicture.getLocation().y;
            int diffX = e.getX() - this.getWidth() / 2;
            int diffY = e.getY() - this.getHeight() / 2;
            this.jLPicture.setLocation(this.jLPicture.getLocation().x - diffX, this.jLPicture.getLocation().y - diffY);
            this.SET_CENTER = false;
            return;
        }
        if (this.SHIFT_PRESSED && !this.STRG_PRESSED && e.getButton() == 1) {
            if (n != null) {
                if (this.selNode.isSelected(p)) {
                    this.selNode.selectNode(p, false);
                } else {
                    this.selNode.selectNode(p, true);
                }
            }
            return;
        }
        if (this.STRG_PRESSED && !this.SHIFT_PRESSED && this.selNode.hasSelectedNodes()) {
            if (n != null) {
                if (e.getButton() == 1) {
                    this.selNode.linkToNode(p);
                } else if (e.getButton() == 3) {
                    this.selNode.deleteLinksToNode(p);
                }
                this.repaint();
            }
            return;
        }
        if (this.selNode.hasSelectedNodes() && !this.STRG_PRESSED && !this.SHIFT_PRESSED) {
            this.selNode.removeAll();
            if (n != null) {
                this.selNode.selectNode(p, true);
            }
            this.repaint();
            return;
        }
        if (n != null && e.getModifiers() == 4 && !this.STRG_PRESSED && !this.SHIFT_PRESSED) {
            EditNodeDlg editNode = new EditNodeDlg((Frame)this.netfield, true, p, this.nm_handler.isKante2allowed());
            editNode.setLocation(posX, posY);
            if (p.getN().getAnonAbk().startsWith("P") && !p.getN().getAnonAbk().equals("Pr")) {
                editNode.setPARTNER(true);
            }
            editNode.setVisible(true);
            if (editNode.isDelete()) {
                this.nm_handler.remove(n.getID(), this.nm_handler.getNodeHandler().getNh_id());
            } else if (editNode.isOK()) {
                n.setName(editNode.getNodeName());
                p.setKante(editNode.getKante());
                if (editNode.isMaennlich()) {
                    n.setMaennlich();
                } else {
                    n.setWeiblich();
                }
                p.getN().setNotiz(editNode.getNotiz());
                p.getN().setAnonAbk(editNode.getAnonymZeichen());
                String s = p.getN().getAnonAbk();
                for (AbkKatalog k : this.nm_handler.getAbkkat()) {
                    if (!s.equals(k.getAbk())) continue;
                    p.getN().setAnonForSaving(k.getAbkForSaving());
                    break;
                }
            }
            this.netfield.toFront();
        }
        if (!(n == null || e.getButton() != 1 || this.selNode.hasSelectedNodes() || this.STRG_PRESSED || this.SHIFT_PRESSED)) {
            this.selNode.selectNode(p, true);
        }
        if (!this.selNode.hasSelectedNodes() && e.getButton() == 1 && !this.STRG_PRESSED && n == null) {
            Position pos = this.nm_handler.add((double)posX / (double)this.width, (double)posY / (double)this.height, "");
            EditNodeDlg edia = new EditNodeDlg((Frame)this.netfield, true, pos, this.nm_handler.isKante2allowed());
            edia.setLocation(posX, posY);
            edia.setNewNode();
            edia.setVisible(true);
            if (edia.isDelete() || !edia.isOK()) {
                this.nm_handler.remove(pos.getN().getID(), this.nm_handler.getNodeHandler().getNh_id());
            } else if (edia.isOK()) {
                pos.getN().setName(edia.getNodeName());
                pos.setKante(edia.getKante());
                if (edia.isMaennlich()) {
                    pos.getN().setMaennlich();
                } else {
                    pos.getN().setWeiblich();
                }
                pos.getN().setNotiz(edia.getNotiz());
                pos.getN().setAnonAbk(edia.getAnonymZeichen());
                String s = pos.getN().getAnonAbk();
                for (AbkKatalog k : this.nm_handler.getAbkkat()) {
                    if (!s.equals(k.getAbk())) continue;
                    pos.getN().setAnonForSaving(k.getAbkForSaving());
                    break;
                }
            }
            this.netfield.toFront();
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.KOPY_FIELD) {
            return;
        }
        int posX = e.getX();
        int posY = e.getY();
        if (this.MOVING_PICTURE) {
            this.orig_pX += e.getX() - this.pX;
            this.orig_pY += e.getY() - this.pY;
            this.pX = e.getX();
            this.pY = e.getY();
            this.jLPicture.setLocation(this.orig_pX, this.orig_pY);
        }
        if (!this.selNode.hasSelectedNodes() || this.SHIFT_PRESSED) {
            this.selRect_posX2 = (double)posX / (double)this.getWidth();
            this.selRect_posY2 = (double)posY / (double)this.getHeight();
            this.repaint();
        } else {
            this.selNode.moveSelected((double)posX / (double)this.getWidth(), (double)posY / (double)this.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.KOPY_FIELD) {
            return;
        }
        int posX = e.getX();
        int posY = e.getY();
        if (this.MOVE_PICTURE) {
            this.pX = e.getX();
            this.pY = e.getY();
            this.MOVING_PICTURE = true;
            return;
        }
        if (!this.selNode.hasSelectedNodes() || this.SHIFT_PRESSED) {
            this.selRect_posX1 = (double)posX / (double)this.getWidth();
            this.selRect_posY1 = (double)posY / (double)this.getHeight();
        } else {
            this.selNode.moveSelected((double)posX / (double)this.getWidth(), (double)posY / (double)this.getHeight());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.KOPY_FIELD) {
            return;
        }
        if (this.MOVING_PICTURE) {
            boolean bl = this.MOVING_PICTURE = !this.MOVING_PICTURE;
        }
        if (!this.selNode.hasSelectedNodes() || this.SHIFT_PRESSED) {
            this.selNode.selectInRect(this.selRect_posX1, this.selRect_posY1, this.selRect_posX2, this.selRect_posY2);
            this.selRect_posY2 = -1.0;
            this.selRect_posY1 = -1.0;
            this.selRect_posX2 = -1.0;
            this.selRect_posX1 = -1.0;
            this.repaint();
        } else {
            this.selNode.setStatus(2);
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.MOUSE_SAVE_POSITOIN = true;
    }

    public void mouseExited(MouseEvent e) {
        this.MOUSE_SAVE_POSITOIN = false;
    }

    public void mouseMoved(MouseEvent e) {
        if (this.MOUSE_SAVE_POSITOIN) {
            this.mouse_posX = e.getPoint().x;
            this.mouse_posY = e.getPoint().y;
            this.repaint();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 600);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        int ans;
        if (this.KOPY_FIELD) {
            return;
        }
        if (e.getKeyCode() == 17 || e.getKeyCode() == 157) {
            this.STRG_PRESSED = true;
        }
        if (e.getKeyCode() == 16) {
            this.SHIFT_PRESSED = true;
        }
        if (e.getKeyCode() == 127 && (ans = JOptionPane.showConfirmDialog(this.netfield, this.netfield.getTranslation("dialogMsgDeleteNodeText"), this.netfield.getTranslation("dialogMsgDeleteNodeTitle"), 0)) == 0) {
            this.selNode.deleteNodes();
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.KOPY_FIELD) {
            return;
        }
        if (e.getKeyCode() == 17) {
            this.STRG_PRESSED = false;
        }
        if (e.getKeyCode() == 16 || e.getKeyCode() == 17) {
            this.SHIFT_PRESSED = false;
        }
    }

    private void mouseClicked_CopyField(MouseEvent e) {
        this.netfield.getList_pos().get(this.netfield.getPos_copy_person()).setPosX((double)e.getX() / (double)this.getWidth());
        this.netfield.getList_pos().get(this.netfield.getPos_copy_person()).setPosY((double)e.getY() / (double)this.getHeight());
        this.nm_handler.getPositions().add(this.netfield.getList_pos().get(this.netfield.getPos_copy_person()));
        this.netfield.setPos_copy_person(this.netfield.getPos_copy_person() + 1);
        if (this.netfield.getPos_copy_person() >= this.netfield.getList_pos().size()) {
            this.netfield.setKOPY_FIELD(false);
            for (Link l : this.netfield.getList_link()) {
                this.nm_handler.getLinks().add(l);
            }
        }
        this.repaint();
    }

    public boolean isFIRST_START() {
        return this.FIRST_START;
    }

    public void setFIRST_START(boolean FIRST_START) {
        this.FIRST_START = FIRST_START;
    }

    public void setSTRG_PRESSED(boolean STRG_PRESSED) {
        this.STRG_PRESSED = STRG_PRESSED;
    }

    public boolean isSTRG_PRESSED() {
        return this.STRG_PRESSED;
    }

    public NodeSelectionHandler getSelNode() {
        return this.selNode;
    }

    public void setSelNode(NodeSelectionHandler selNode) {
        this.selNode = selNode;
    }

    public NodeMetaHandler getNodeMetaHandler() {
        return this.nm_handler;
    }

    public void setNodeMetaHandler(NodeMetaHandler nm_handler) {
        this.nm_handler = nm_handler;
    }

    public boolean isHAS_PICTURE() {
        return this.HAS_PICTURE;
    }

    public void setHAS_PICTURE(boolean HAS_PICTURE) {
        this.HAS_PICTURE = HAS_PICTURE;
    }

    public boolean isMOVE_PICTURE() {
        return this.MOVE_PICTURE;
    }

    public void setMOVE_PICTURE(boolean MOVE_PICTURE) {
        this.MOVE_PICTURE = MOVE_PICTURE;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public JLabel getjLPicture() {
        return this.jLPicture;
    }

    public void setjLPicture(MyLabel jLPicture) {
        this.jLPicture = jLPicture;
        jLPicture.setField(this);
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public ImageIcon getIcon_copy() {
        return this.icon_copy;
    }

    public void setIcon_copy(ImageIcon icon_copy) {
        this.icon_copy = icon_copy;
    }

    public int getCenter_picX() {
        return this.center_picX;
    }

    public void setCenter_picX(int center_picX) {
        this.center_picX = center_picX;
    }

    public int getCenter_picY() {
        return this.center_picY;
    }

    public void setCenter_picY(int center_picY) {
        this.center_picY = center_picY;
    }

    public boolean isSET_CENTER() {
        return this.SET_CENTER;
    }

    public void setSET_CENTER(boolean SET_CENTER) {
        this.SET_CENTER = SET_CENTER;
    }

    public NetworkField getNetfield() {
        return this.netfield;
    }

    public void setNetfield(NetworkField netfield) {
        this.netfield = netfield;
    }

    public boolean isKOPY_FIELD() {
        return this.KOPY_FIELD;
    }

    public void setKOPY_FIELD(boolean KOPY_FIELD) {
        this.KOPY_FIELD = KOPY_FIELD;
    }

    public boolean isDRAW_CIRCLES() {
        return this.DRAW_CIRCLES;
    }

    public void setDRAW_CIRCLES(boolean DRAW_CIRCLES) {
        this.DRAW_CIRCLES = DRAW_CIRCLES;
    }
}

