/*
 * Decompiled with CFR 0.152.
 */
package netzwerkkarte;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import language.Language;
import language.LanguageChangedEvent;
import language.LanguageChangedListener;
import language.LanguageHandler;
import netzwerk.dialog.AboutDlg;
import netzwerk.dialog.BeziehungCheckDlg;
import netzwerk.dialog.EgoPersonDlg;
import netzwerk.dialog.FirstStartDlg;
import netzwerk.dialog.InfoDlg;
import netzwerk.dialog.PreferedSizeDlg;
import netzwerk.exception.ParseIntException;
import netzwerkkarte.Field;
import netzwerkkarte.ImageStore;
import netzwerkkarte.SVGExport;
import nodehandler.AbkKatalog;
import nodehandler.Link;
import nodehandler.Node;
import nodehandler.Position;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkField
extends JFrame
implements LanguageChangedListener {
    public static final String VERSION = "1.5.0";
    private Field field = null;
    private boolean HAS_NO_EGOPERS = true;
    private boolean SAVED = false;
    private boolean MAKE_ALL = false;
    private boolean ANONYM = false;
    public LanguageHandler languageHandler;
    public LanguageChangedEvent languageChangedEvent;
    List<Position> list_pos = new LinkedList<Position>();
    Collection<Link> list_link = new HashSet<Link>(0);
    int pos_copy_person = -1;
    private JButton jBAdd;
    private JButton jB_Beziehungen;
    private JButton jB_Egoperson;
    private JButton jB_Load;
    private JButton jB_Neu;
    private JButton jB_Paketspeicherung;
    private JButton jB_Speichern;
    private JButton jB_VerkLoesch;
    private JButton jB_VernkErst;
    private JButton jBleft;
    private JButton jBright;
    private JLabel jLFieldMax;
    private JLabel jLKarte;
    private JMenu jMAbout;
    private JMenu jMDatei;
    private JMenu jMExportJPG;
    private JMenu jMExportSVG;
    private JMenuItem jMIZeichne_Kreise;
    private JMenuItem jMI_About;
    private JMenuItem jMI_AnalyeAll;
    private JMenuItem jMI_AnalyseStarten;
    private JMenuItem jMI_Anonymisieren;
    private JMenuItem jMI_Beenden;
    private JMenuItem jMI_BeziehungCheck;
    private JMenuItem jMI_BildLaden;
    private JMenuItem jMI_Clusterverk_erstellen;
    private JMenuItem jMI_Clusterverk_loeschen;
    private JMenuItem jMI_DeleteField;
    private JMenuItem jMI_EgoPersonSetzen;
    private JMenuItem jMI_Info;
    private JMenuItem jMI_Laden;
    private JMenuItem jMI_Neu;
    private JMenuItem jMI_Paketspeicherung;
    private JMenuItem jMI_PersonenKopieren;
    private JMenuItem jMI_Speichern;
    private JMenuItem jMI_SpeichernUnter;
    private JMenuItem jMI_VektorgrafikExp;
    private JMenuItem jMI_VektorgrafikExpAlles;
    private JMenuItem jMI_jpgGrafikExp;
    private JMenuItem jMI_jpgGrafikExpAlles;
    private JMenu jMLanguage;
    private JMenu jMVerwalten;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPopupMenu.Separator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JSeparator jSeparator6;
    private JTextField jTFFieldNr;
    private JToolBar jToolBar1;

    public NetworkField() {
        this.setTitle("easyNWK PRO v1.5.0");
        this.setSize((int)Toolkit.getDefaultToolkit().getScreenSize().getHeight(), (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        this.initLanguage();
        this.loadSettings();
        this.field = new Field(this);
        this.initComponents();
        this.addLanguageMenuItems();
        this.setDefaultCloseOperation(0);
        this.handleLinuxWindowsMaximiseProblem();
        this.field.setFIRST_START(true);
        this.setHAS_NO_EGOPERS(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                NetworkField.this.jMI_BeendenActionPerformed(null);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
            }
        });
        this.add((Component)this.field, "Center");
        this.addKeyListener(this.field);
        this.field.getNodeMetaHandler().setPath(new File(".").getPath());
        this.setVisible(true);
        FirstStartDlg fdlg = new FirstStartDlg((Frame)this, true);
        fdlg.setLocation(this.getHeight() / 2, this.getWidth() / 2);
        fdlg.setVisible(true);
        if (fdlg.isNeu()) {
            this.jMI_NeuActionPerformed(null);
        }
        if (fdlg.isBeenden()) {
            this.jMI_BeendenActionPerformed(null);
        }
        if (fdlg.isLaden()) {
            this.jMI_LadenActionPerformed(null);
        }
        this.repaint();
    }

    private void addLanguageMenuItems() {
        LinkedList<Language> lList = this.languageHandler.getLanguages();
        for (Language l : lList) {
            JMenuItem jmenu = new JMenuItem(l.getLanguagename() + " (" + l.getLanguageNameInEnglish() + ")");
            jmenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String language = ((JMenuItem)evt.getSource()).getText();
                    language = language.split(" ")[0];
                    NetworkField.this.languageHandler.setCurrentLanguage(language);
                    NetworkField.this.languageChangedEvent.languageHasChanged();
                    NetworkField.this.saveSettings();
                }
            });
            this.jMLanguage.add(jmenu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        FileWriter fwrite = null;
        File file = new File(".\\settings.xml");
        this.createSettingsFileIfNotExists(file);
        try {
            fwrite = new FileWriter(file);
            fwrite.write("<optionsetting>\n");
            fwrite.write("   <settingsvalue id=\"languageID\">" + this.languageHandler.getCurrentLanguageID() + "</settingsvalue>\n");
            fwrite.write("</optionsetting>\n");
        }
        catch (IOException ex) {
            Logger.getLogger(NetworkField.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fwrite.close();
            }
            catch (IOException ex) {
                Logger.getLogger(NetworkField.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public boolean loadSettings() {
        File file = new File(".\\settings.xml");
        if (!file.exists()) {
            return false;
        }
        try {
            Document doc = Jsoup.parse(new FileInputStream(file), "UTF-8", "http://example.com");
            String languageID = doc.getElementById("languageID").text();
            this.languageHandler.setCurrentLanguage(languageID);
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(NetworkField.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    private void createSettingsFileIfNotExists(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                System.out.println("creating settings.xml file is not working!");
            }
        }
    }

    private void handleLinuxWindowsMaximiseProblem() throws HeadlessException {
        if (System.getProperty("os.name").equals("Linux")) {
            int h = Toolkit.getDefaultToolkit().getScreenSize().getSize().height - 45;
            this.setSize(h, h);
            this.setResizable(false);
        } else {
            this.setSize((int)Toolkit.getDefaultToolkit().getScreenSize().getHeight(), (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLKarte = new JLabel();
        this.jBleft = new JButton();
        this.jTFFieldNr = new JTextField();
        this.jLFieldMax = new JLabel();
        this.jBright = new JButton();
        this.jBAdd = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jB_Neu = new JButton();
        this.jB_Load = new JButton();
        this.jB_Speichern = new JButton();
        this.jB_Paketspeicherung = new JButton();
        this.jSeparator5 = new JToolBar.Separator();
        this.jB_Egoperson = new JButton();
        this.jB_Beziehungen = new JButton();
        this.jB_VernkErst = new JButton();
        this.jB_VerkLoesch = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMDatei = new JMenu();
        this.jMI_Neu = new JMenuItem();
        this.jMI_Laden = new JMenuItem();
        this.jMI_Speichern = new JMenuItem();
        this.jMI_SpeichernUnter = new JMenuItem();
        this.jMI_Paketspeicherung = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMI_Beenden = new JMenuItem();
        this.jMVerwalten = new JMenu();
        this.jMI_EgoPersonSetzen = new JMenuItem();
        this.jMIZeichne_Kreise = new JMenuItem();
        this.jMI_Anonymisieren = new JMenuItem();
        this.jMI_BildLaden = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMI_BeziehungCheck = new JMenuItem();
        this.jMI_Clusterverk_erstellen = new JMenuItem();
        this.jMI_Clusterverk_loeschen = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.jMExportJPG = new JMenu();
        this.jMI_jpgGrafikExp = new JMenuItem();
        this.jMI_jpgGrafikExpAlles = new JMenuItem();
        this.jMExportSVG = new JMenu();
        this.jMI_VektorgrafikExp = new JMenuItem();
        this.jMI_VektorgrafikExpAlles = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.jMI_PersonenKopieren = new JMenuItem();
        this.jMI_DeleteField = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.jMenu1 = new JMenu();
        this.jMI_AnalyseStarten = new JMenuItem();
        this.jMI_AnalyeAll = new JMenuItem();
        this.jMLanguage = new JMenu();
        this.jMAbout = new JMenu();
        this.jMI_Info = new JMenuItem();
        this.jMI_About = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setFocusable(false);
        this.jPanel1.setLayout(new GridLayout(1, 0));
        this.jLKarte.setText(this.languageHandler.getTranslation("labelFooterCards"));
        this.jLKarte.setFocusable(false);
        this.jPanel1.add(this.jLKarte);
        this.jBleft.setText("<");
        this.jBleft.setFocusable(false);
        this.jBleft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jBleftActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jBleft);
        this.jTFFieldNr.setText("1");
        this.jTFFieldNr.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                NetworkField.this.jTFFieldNrKeyTyped(evt);
            }

            public void keyPressed(KeyEvent evt) {
                NetworkField.this.jTFFieldNrKeyPressed(evt);
            }
        });
        this.jPanel1.add(this.jTFFieldNr);
        this.jLFieldMax.setText("/1");
        this.jLFieldMax.setFocusable(false);
        this.jPanel1.add(this.jLFieldMax);
        this.jBright.setText(">");
        this.jBright.setFocusable(false);
        this.jBright.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jBrightActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jBright);
        this.jBAdd.setText("+");
        this.jBAdd.setFocusable(false);
        this.jBAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jBAddActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jBAdd);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jB_Neu.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/add_32x32.png")));
        this.jB_Neu.setToolTipText(this.getTranslation("menuItemDataNew"));
        this.jB_Neu.setFocusable(false);
        this.jB_Neu.setHorizontalTextPosition(0);
        this.jB_Neu.setVerticalTextPosition(3);
        this.jB_Neu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_NeuActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Neu);
        this.jB_Load.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/document_32x32.png")));
        this.jB_Load.setToolTipText(this.getTranslation("menuItemDataLoad"));
        this.jB_Load.setFocusable(false);
        this.jB_Load.setHorizontalTextPosition(0);
        this.jB_Load.setVerticalTextPosition(3);
        this.jB_Load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_LoadActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Load);
        this.jB_Speichern.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/save_32x32.png")));
        this.jB_Speichern.setToolTipText(this.getTranslation("menuItemDataSave"));
        this.jB_Speichern.setFocusable(false);
        this.jB_Speichern.setHorizontalTextPosition(0);
        this.jB_Speichern.setVerticalTextPosition(3);
        this.jB_Speichern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_SpeichernActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Speichern);
        this.jB_Paketspeicherung.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/database_32x32.png")));
        this.jB_Paketspeicherung.setToolTipText(this.getTranslation("menuItemDataSavePackage"));
        this.jB_Paketspeicherung.setFocusable(false);
        this.jB_Paketspeicherung.setHorizontalTextPosition(0);
        this.jB_Paketspeicherung.setVerticalTextPosition(3);
        this.jB_Paketspeicherung.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_PaketspeicherungActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Paketspeicherung);
        this.jToolBar1.add(this.jSeparator5);
        this.jB_Egoperson.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/user_32x32.png")));
        this.jB_Egoperson.setToolTipText(this.getTranslation("menuItemAdministrateClient"));
        this.jB_Egoperson.setFocusable(false);
        this.jB_Egoperson.setHorizontalTextPosition(0);
        this.jB_Egoperson.setVerticalTextPosition(3);
        this.jB_Egoperson.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_EgopersonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Egoperson);
        this.jB_Beziehungen.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/workflow_32x32.png")));
        this.jB_Beziehungen.setToolTipText(this.getTranslation("menuItemAdministrateManageRelation"));
        this.jB_Beziehungen.setFocusable(false);
        this.jB_Beziehungen.setHorizontalTextPosition(0);
        this.jB_Beziehungen.setVerticalTextPosition(3);
        this.jB_Beziehungen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_BeziehungenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Beziehungen);
        this.jB_VernkErst.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/link_32x32.png")));
        this.jB_VernkErst.setToolTipText(this.getTranslation("menuItemAdministrateCreateClusterRelation"));
        this.jB_VernkErst.setFocusable(false);
        this.jB_VernkErst.setHorizontalTextPosition(0);
        this.jB_VernkErst.setVerticalTextPosition(3);
        this.jB_VernkErst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_VernkErstActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_VernkErst);
        this.jB_VerkLoesch.setIcon(new ImageIcon(this.getClass().getResource("/netzwerk/pics/delete_32x32.png")));
        this.jB_VerkLoesch.setToolTipText(this.getTranslation("menuItemAdministrateDeleteClusterRelation"));
        this.jB_VerkLoesch.setFocusable(false);
        this.jB_VerkLoesch.setHorizontalTextPosition(0);
        this.jB_VerkLoesch.setVerticalTextPosition(3);
        this.jB_VerkLoesch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jB_VerkLoeschActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_VerkLoesch);
        this.getContentPane().add((Component)this.jToolBar1, "West");
        this.jMDatei.setText(this.languageHandler.getTranslation("menuItemData"));
        this.jMDatei.setMnemonic('M');
        this.jMI_Neu.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMI_Neu.setText(this.languageHandler.getTranslation("menuItemDataNew"));
        this.jMI_Neu.setMnemonic('N');
        this.jMI_Neu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_NeuActionPerformed(evt);
            }
        });
        this.jMDatei.add(this.jMI_Neu);
        this.jMI_Laden.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMI_Laden.setText(this.languageHandler.getTranslation("menuItemDataLoad"));
        this.jMI_Laden.setMnemonic('L');
        this.jMI_Laden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_LadenActionPerformed(evt);
            }
        });
        this.jMDatei.add(this.jMI_Laden);
        this.jMI_Speichern.setText(this.languageHandler.getTranslation("menuItemDataSave"));
        this.jMI_Speichern.setMnemonic('S');
        this.jMI_Speichern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_SpeichernActionPerformed(evt);
            }
        });
        this.jMDatei.add(this.jMI_Speichern);
        this.jMI_SpeichernUnter.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.jMI_SpeichernUnter.setText(this.languageHandler.getTranslation("menuItemDataSaveAs"));
        this.jMI_SpeichernUnter.setMnemonic('u');
        this.jMI_SpeichernUnter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_SpeichernUnterActionPerformed(evt);
            }
        });
        this.jMDatei.add(this.jMI_SpeichernUnter);
        this.jMI_Paketspeicherung.setText(this.languageHandler.getTranslation("menuItemDataSavePackage"));
        this.jMI_Paketspeicherung.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_PaketspeicherungActionPerformed(evt);
            }
        });
        this.jMDatei.add(this.jMI_Paketspeicherung);
        this.jMDatei.add(this.jSeparator1);
        this.jMI_Beenden.setText(this.languageHandler.getTranslation("menuItemDataClose"));
        this.jMI_Beenden.setMnemonic('d');
        this.jMI_Beenden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_BeendenActionPerformed(evt);
            }
        });
        this.jMDatei.add(this.jMI_Beenden);
        this.jMenuBar1.add(this.jMDatei);
        this.jMVerwalten.setText(this.languageHandler.getTranslation("menuItemAdministrate"));
        this.jMI_EgoPersonSetzen.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.jMI_EgoPersonSetzen.setText(this.languageHandler.getTranslation("menuItemAdministrateClient"));
        this.jMI_EgoPersonSetzen.setMnemonic('E');
        this.jMI_EgoPersonSetzen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_EgoPersonSetzenActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_EgoPersonSetzen);
        this.jMIZeichne_Kreise.setText(this.languageHandler.getTranslation("menuItemAdministrateShowHorizons"));
        this.jMIZeichne_Kreise.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMIZeichne_KreiseActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMIZeichne_Kreise);
        this.jMI_Anonymisieren.setText(this.languageHandler.getTranslation("menuItemAdministrateAnonymization"));
        this.jMI_Anonymisieren.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_AnonymisierenActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_Anonymisieren);
        this.jMI_BildLaden.setText(this.languageHandler.getTranslation("menuItemAdministrateLoadPicture"));
        this.jMI_BildLaden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_BildLadenActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_BildLaden);
        this.jMVerwalten.add(this.jSeparator2);
        this.jMI_BeziehungCheck.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.jMI_BeziehungCheck.setText(this.languageHandler.getTranslation("menuItemAdministrateManageRelation"));
        this.jMI_BeziehungCheck.setMnemonic('k');
        this.jMI_BeziehungCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_BeziehungCheckActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_BeziehungCheck);
        this.jMI_Clusterverk_erstellen.setAccelerator(KeyStroke.getKeyStroke(69, 8));
        this.jMI_Clusterverk_erstellen.setText(this.languageHandler.getTranslation("menuItemAdministrateCreateClusterRelation"));
        this.jMI_Clusterverk_erstellen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_Clusterverk_erstellenActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_Clusterverk_erstellen);
        this.jMI_Clusterverk_loeschen.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.jMI_Clusterverk_loeschen.setText(this.languageHandler.getTranslation("menuItemAdministrateDeleteClusterRelation"));
        this.jMI_Clusterverk_loeschen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_Clusterverk_loeschenActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_Clusterverk_loeschen);
        this.jMVerwalten.add(this.jSeparator4);
        this.jMExportJPG.setText(this.languageHandler.getTranslation("menuItemAdministrateExportJPG"));
        this.jMI_jpgGrafikExp.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.jMI_jpgGrafikExp.setText(this.languageHandler.getTranslation("menuItemAdministrateExportActualCard"));
        this.jMI_jpgGrafikExp.setMnemonic('j');
        this.jMI_jpgGrafikExp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_jpgGrafikExpActionPerformed(evt);
            }
        });
        this.jMExportJPG.add(this.jMI_jpgGrafikExp);
        this.jMI_jpgGrafikExpAlles.setText(this.languageHandler.getTranslation("menuItemAdministrateExportAllCards"));
        this.jMI_jpgGrafikExpAlles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_jpgGrafikExpAllesActionPerformed(evt);
            }
        });
        this.jMExportJPG.add(this.jMI_jpgGrafikExpAlles);
        this.jMVerwalten.add(this.jMExportJPG);
        this.jMExportSVG.setText(this.languageHandler.getTranslation("menuItemAdministrateExportSVG"));
        this.jMI_VektorgrafikExp.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMI_VektorgrafikExp.setText(this.languageHandler.getTranslation("menuItemAdministrateExportActualCard"));
        this.jMI_VektorgrafikExp.setMnemonic('V');
        this.jMI_VektorgrafikExp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_VektorgrafikExpActionPerformed(evt);
            }
        });
        this.jMExportSVG.add(this.jMI_VektorgrafikExp);
        this.jMI_VektorgrafikExpAlles.setText(this.languageHandler.getTranslation("menuItemAdministrateExportAllCards"));
        this.jMI_VektorgrafikExpAlles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_VektorgrafikExpAllesActionPerformed(evt);
            }
        });
        this.jMExportSVG.add(this.jMI_VektorgrafikExpAlles);
        this.jMVerwalten.add(this.jMExportSVG);
        this.jMVerwalten.add(this.jSeparator3);
        this.jMI_PersonenKopieren.setText(this.languageHandler.getTranslation("menuItemAdministrateCopyPersonFromFormerCard"));
        this.jMI_PersonenKopieren.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_PersonenKopierenActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_PersonenKopieren);
        this.jMI_DeleteField.setText(this.languageHandler.getTranslation("menuItemAdministrateDeleteLastCard"));
        this.jMI_DeleteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_DeleteFieldActionPerformed(evt);
            }
        });
        this.jMVerwalten.add(this.jMI_DeleteField);
        this.jMVerwalten.add(this.jSeparator6);
        this.jMenu1.setText(this.languageHandler.getTranslation("menuItemAdministrateAnalyse"));
        this.jMI_AnalyseStarten.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.jMI_AnalyseStarten.setText(this.languageHandler.getTranslation("menuItemAdministrateExportActualCard"));
        this.jMI_AnalyseStarten.setMnemonic('A');
        this.jMI_AnalyseStarten.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_AnalyseStartenActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMI_AnalyseStarten);
        this.jMI_AnalyeAll.setText(this.languageHandler.getTranslation("menuItemAdministrateExportAllCards"));
        this.jMI_AnalyeAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_AnalyeAllActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMI_AnalyeAll);
        this.jMVerwalten.add(this.jMenu1);
        this.jMenuBar1.add(this.jMVerwalten);
        this.jMLanguage.setText("Language (" + this.languageHandler.getTranslation("menuItemLanguage") + ")");
        this.jMenuBar1.add(this.jMLanguage);
        this.jMAbout.setText(this.languageHandler.getTranslation("menuItemAbout"));
        this.jMI_Info.setText(this.languageHandler.getTranslation("menuItemAboutInfo"));
        this.jMI_Info.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_InfoActionPerformed(evt);
            }
        });
        this.jMAbout.add(this.jMI_Info);
        this.jMI_About.setText(this.languageHandler.getTranslation("menuItemAbout"));
        this.jMI_About.setMnemonic('t');
        this.jMI_About.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NetworkField.this.jMI_AboutActionPerformed(evt);
            }
        });
        this.jMAbout.add(this.jMI_About);
        this.jMenuBar1.add(this.jMAbout);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jMI_BeendenActionPerformed(ActionEvent evt) {
        Object[] objects = new Object[]{"Ja", "Nein", "Abbrechen"};
        if (this.field.getNodeMetaHandler().getNumNodes() == 0 && this.field.getNodeMetaHandler().getLinks().size() == 0 && !this.field.getNodeMetaHandler().hasEgo_person()) {
            this.dispose();
            return;
        }
        int res = JOptionPane.showOptionDialog(null, this.getTranslation("dialogMsgSaveBevorClosingText"), this.getTranslation("dialogMsgSaveBevorClosingTitle"), -1, 3, null, objects, null);
        if (res == 0) {
            this.SAVED = false;
            this.jMI_SpeichernActionPerformed(evt);
            if (!this.SAVED) {
                res = 2;
            }
        }
        this.toFront();
        if (res == 2) {
            return;
        }
        this.dispose();
    }

    private void jMI_AboutActionPerformed(ActionEvent evt) {
        new AboutDlg(null, true).setVisible(true);
        this.toFront();
    }

    private void jMI_InfoActionPerformed(ActionEvent evt) {
        InfoDlg idlg = new InfoDlg((Frame)this, true);
        idlg.setVisible(true);
        this.toFront();
    }

    private void jMI_AnalyseStartenActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("CSV File", "csv");
            if (this.field.getNodeMetaHandler().getSavePath() == null ? "" != null : !this.field.getNodeMetaHandler().getSavePath().equals("")) {
                chooser.setCurrentDirectory(new File(this.field.getNodeMetaHandler().getSavePath()));
            }
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0) {
                String path = chooser.getSelectedFile().getAbsolutePath();
                if (!path.toUpperCase().endsWith(".CSV")) {
                    path = path + ".csv";
                }
                this.field.getNodeMetaHandler().analyse(new File(path), this.MAKE_ALL);
                JOptionPane.showMessageDialog(null, "Analyse ist beendet.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_VektorgrafikExpActionPerformed(ActionEvent evt) {
        SVGExport img = new SVGExport(this.field);
        PreferedSizeDlg prefsize = new PreferedSizeDlg((Frame)this, true);
        prefsize.setVisible(true);
        if (prefsize.isOk()) {
            int width = prefsize.getsize();
            try {
                JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("SVG File", "svg");
                if (this.field.getNodeMetaHandler().getSavePath() == null ? "" != null : !this.field.getNodeMetaHandler().getSavePath().equals("")) {
                    chooser.setCurrentDirectory(new File(this.field.getNodeMetaHandler().getSavePath()));
                }
                chooser.setFileFilter(filter);
                int returnVal = chooser.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    String path = chooser.getSelectedFile().getAbsolutePath();
                    if (file.getName().toUpperCase().endsWith(".SVG")) {
                        String a = file.getAbsolutePath();
                        a = a.substring(0, a.length() - 4);
                        file = new File(a);
                        System.out.println(a);
                    }
                    if (this.MAKE_ALL) {
                        int pos_aktuel = this.field.getNodeMetaHandler().getPos();
                        for (int i = 0; i < this.field.getNodeMetaHandler().getNhandler().size(); ++i) {
                            this.field.getNodeMetaHandler().setNodeHandler(i);
                            img.store(file.getAbsolutePath() + "_" + (1000 + i) + ".svg", width, width);
                        }
                        this.field.getNodeMetaHandler().setPos(pos_aktuel);
                    } else {
                        if (!path.toUpperCase().endsWith(".SVG")) {
                            path = path + ".svg";
                        }
                        img.store(path, width, width);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_jpgGrafikExpActionPerformed(ActionEvent evt) {
        ImageStore img = new ImageStore(this.field);
        PreferedSizeDlg prefsize = new PreferedSizeDlg((Frame)this, true);
        prefsize.setVisible(true);
        if (prefsize.isOk()) {
            int width = prefsize.getsize();
            try {
                JFileChooser chooser = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("JPG File", "jpg");
                if (this.field.getNodeMetaHandler().getSavePath() == null ? "" != null : !this.field.getNodeMetaHandler().getSavePath().equals("")) {
                    chooser.setCurrentDirectory(new File(this.field.getNodeMetaHandler().getSavePath()));
                }
                chooser.setFileFilter(filter);
                int returnVal = chooser.showSaveDialog(null);
                if (returnVal == 0) {
                    File file = chooser.getSelectedFile();
                    String path = file.getAbsolutePath();
                    if (file.getName().toUpperCase().endsWith(".JPG")) {
                        String a = file.getAbsolutePath();
                        a = a.substring(0, a.length() - 4);
                        file = new File(a);
                        System.out.println(a);
                    }
                    if (this.MAKE_ALL) {
                        int pos_aktuel = this.field.getNodeMetaHandler().getPos();
                        for (int i = 0; i < this.field.getNodeMetaHandler().getNhandler().size(); ++i) {
                            this.field.getNodeMetaHandler().setNodeHandler(i);
                            img.store(width, width, file.getAbsolutePath() + "_" + (1000 + i) + ".jpg");
                        }
                        this.field.getNodeMetaHandler().setPos(pos_aktuel);
                    } else {
                        if (!path.toUpperCase().endsWith(".jpg")) {
                            path = path + ".jpg";
                        }
                        img.store(width, width, path);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_Clusterverk_loeschenActionPerformed(ActionEvent evt) {
        this.field.getSelNode().deleteAllLinks();
        this.toFront();
    }

    private void jMI_Clusterverk_erstellenActionPerformed(ActionEvent evt) {
        this.field.getSelNode().linkAllNodes();
        this.toFront();
    }

    private void jMI_BeziehungCheckActionPerformed(ActionEvent evt) {
        if (this.field.getNodeMetaHandler().getNumNodes() <= 1) {
            this.doSaveError(this.getTranslation("dialogMsgNotEnoughPersonsText"), this.getTranslation("dialogMsgNotEnoughPersonsTitle"));
            return;
        }
        BeziehungCheckDlg bcdlg = new BeziehungCheckDlg((Frame)this, this.HAS_NO_EGOPERS, this);
        if (this.field.getSelNode().countSelected() == 1) {
            bcdlg.TableFromNode(this.field.getSelNode().getPositions().get(0).getN());
        }
        bcdlg.setVisible(true);
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_EgoPersonSetzenActionPerformed(ActionEvent evt) {
        EgoPersonDlg egodlg = new EgoPersonDlg((Frame)this, true);
        if (this.field.getNodeMetaHandler().getEgo_person() != null && !this.field.getNodeMetaHandler().getEgo_person().equals("")) {
            egodlg.setAlter(this.field.getNodeMetaHandler().getAlter());
            egodlg.setEgoPersonName(this.field.getNodeMetaHandler().getEgo_person());
            egodlg.setInfo(this.field.getNodeMetaHandler().getEgo_person_info());
        }
        egodlg.setLocation(this.getHeight() / 2, this.getWidth() / 2);
        egodlg.setVisible(true);
        if (egodlg.getOK()) {
            if (egodlg.getEgoPersonName().trim().equals("")) {
                JOptionPane.showMessageDialog(null, this.getTranslation("dialogMsgNameOfClientMissingText"), this.getTranslation("dialogMsgNameOfClientMissingTitle"), 0);
                this.jMI_EgoPersonSetzenActionPerformed(evt);
                return;
            }
            this.field.getNodeMetaHandler().setEgo_person(egodlg.getEgoPersonName());
            this.field.getNodeMetaHandler().setAlter(egodlg.getAlter());
            this.field.getNodeMetaHandler().setEgo_person_info(egodlg.getInfo());
            this.field.repaint();
        }
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_SpeichernUnterActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Network-File", "nwk");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text File", "txt");
        if (this.field.getNodeMetaHandler().getSavePath() == null ? "" != null : !this.field.getNodeMetaHandler().getSavePath().equals("")) {
            chooser.setCurrentDirectory(new File(this.field.getNodeMetaHandler().getSavePath()));
        }
        chooser.setFileFilter(filter2);
        chooser.addChoosableFileFilter(filter2);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            try {
                File file = chooser.getSelectedFile();
                if (chooser.getFileFilter().accept(new File("a.new")) && !file.getName().toUpperCase().endsWith("NWK")) {
                    file = new File(chooser.getSelectedFile().getAbsolutePath() + ".nwk");
                } else if (chooser.getFileFilter().accept(new File("a.txt")) && !file.getName().toUpperCase().endsWith("TXT")) {
                    file = new File(chooser.getSelectedFile().getAbsolutePath() + ".txt");
                }
                this.field.getNodeMetaHandler().save(file);
                this.SAVED = true;
            }
            catch (IOException ioex) {
                this.doSaveError();
            }
        }
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_SpeichernActionPerformed(ActionEvent evt) {
        if (!this.field.getNodeMetaHandler().getSavePath().equals("")) {
            try {
                this.field.getNodeMetaHandler().save();
                this.SAVED = true;
                return;
            }
            catch (IOException io) {
                this.doSaveError();
            }
        } else {
            this.jMI_SpeichernUnterActionPerformed(evt);
        }
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_LadenActionPerformed(ActionEvent evt) {
        boolean b = false;
        if (this.field.getNodeMetaHandler().getNumNodes() != 0 || this.field.getNodeMetaHandler().hasEgo_person()) {
            if (JOptionPane.showConfirmDialog(null, this.getTranslation("dialogMsgDeleteActualCardText"), this.getTranslation("dialogMsgDeleteActualCardTitle"), 0, 3) == 0 && this.loadField()) {
                this.setHAS_NO_EGOPERS(false);
                this.jTFFieldNr.setText("1");
            }
        } else {
            if (this.loadField()) {
                this.setHAS_NO_EGOPERS(false);
            }
            this.field.repaint();
        }
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.toFront();
    }

    private void jMI_NeuActionPerformed(ActionEvent evt) {
        File file;
        boolean mkdir;
        if ((this.field.getNodeMetaHandler().getNumNodes() != 0 || this.field.getNodeMetaHandler().hasEgo_person()) && JOptionPane.showConfirmDialog(null, this.getTranslation("dialogMsgDeleteActualCardText"), this.getTranslation("dialogMsgDeleteActualCardTitle"), 0, 3) != 0) {
            return;
        }
        this.field.newField();
        this.jMI_EgoPersonSetzenActionPerformed(evt);
        this.checkEgo_person();
        if (!this.HAS_NO_EGOPERS && (mkdir = (file = new File(this.field.getNodeMetaHandler().getEgo_person())).mkdir())) {
            try {
                this.field.getNodeMetaHandler().save(new File(file.getAbsolutePath() + File.separatorChar + this.field.getNodeMetaHandler().getEgo_person() + ".nwk"));
            }
            catch (IOException ex) {
                System.out.println("Fehler beim speichern der Datei w\u00e4hrend dem Anlegen der neuen Karte.\n" + ex.getMessage());
            }
        }
        this.jLFieldMax.setText("/1");
        if (this.field.isSTRG_PRESSED()) {
            this.field.setSTRG_PRESSED(false);
        }
        this.field.repaint();
        this.toFront();
    }

    private void jBleftActionPerformed(ActionEvent evt) {
        this.field.getNodeMetaHandler().prevNodeHandler();
        this.jTFFieldNr.setText("" + (this.field.getNodeMetaHandler().getPos() + 1));
        this.repaint();
    }

    private void jBrightActionPerformed(ActionEvent evt) {
        this.field.getNodeMetaHandler().nextNodeHandler();
        this.jTFFieldNr.setText("" + (this.field.getNodeMetaHandler().getPos() + 1));
        this.repaint();
    }

    private void jBAddActionPerformed(ActionEvent evt) {
        this.field.getNodeMetaHandler().newNodeHandler();
        this.jLFieldMax.setText("/" + this.field.getNodeMetaHandler().getNhandler().size());
        this.jTFFieldNr.setText("" + this.field.getNodeMetaHandler().getNhandler().size());
        this.repaint();
    }

    private void jMI_AnalyeAllActionPerformed(ActionEvent evt) {
        this.MAKE_ALL = true;
        this.jMI_AnalyseStartenActionPerformed(evt);
        this.MAKE_ALL = false;
    }

    private void jMI_jpgGrafikExpAllesActionPerformed(ActionEvent evt) {
        this.MAKE_ALL = true;
        this.jMI_jpgGrafikExpActionPerformed(evt);
        this.MAKE_ALL = false;
    }

    private void jMI_VektorgrafikExpAllesActionPerformed(ActionEvent evt) {
        this.MAKE_ALL = true;
        this.jMI_VektorgrafikExpActionPerformed(evt);
        this.MAKE_ALL = false;
    }

    private void jMI_PaketspeicherungActionPerformed(ActionEvent evt) {
        int width = this.getWidth();
        JFileChooser chooser = new JFileChooser();
        if (this.field.getNodeMetaHandler().getSavePath() == null ? "" != null : !this.field.getNodeMetaHandler().getSavePath().equals("")) {
            chooser.setCurrentDirectory(new File(this.field.getNodeMetaHandler().getSavePath()));
        }
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(this.getTranslation("dialogMsgPleaseChooseFolderTitle"));
        chooser.showOpenDialog(null);
        ImageStore img_jpg = new ImageStore(this.field);
        SVGExport img_svg = new SVGExport(this.field);
        int pos_aktuel = this.field.getNodeMetaHandler().getPos();
        try {
            for (int i = 0; i < this.field.getNodeMetaHandler().getNhandler().size(); ++i) {
                this.field.getNodeMetaHandler().setNodeHandler(i);
                img_svg.store(chooser.getSelectedFile().getAbsoluteFile() + "" + File.separatorChar + this.field.getNodeMetaHandler().getEgo_person() + chooser.getSelectedFile().getName() + "_" + (1000 + i) + ".svg", width, width);
                img_jpg.store(width, width, chooser.getSelectedFile().getAbsoluteFile() + "" + File.separatorChar + chooser.getSelectedFile().getName() + this.field.getNodeMetaHandler().getEgo_person() + "_" + (1000 + i) + ".jpg");
            }
            this.field.getNodeMetaHandler().analyse(new File(chooser.getSelectedFile().getAbsoluteFile() + "" + File.separatorChar + chooser.getSelectedFile().getName() + this.field.getNodeMetaHandler().getEgo_person() + ".csv"), true);
        }
        catch (IOException ex) {
            Logger.getLogger(NetworkField.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception exc) {
            Logger.getLogger(NetworkField.class.getName()).log(Level.SEVERE, null, exc);
        }
        this.field.getNodeMetaHandler().setPos(pos_aktuel);
        this.toFront();
    }

    private void jMI_BildLadenActionPerformed(ActionEvent evt) {
        int i;
        JFileChooser chooser = new JFileChooser();
        if (!this.field.getNodeMetaHandler().getSavePath().equals("")) {
            chooser.setCurrentDirectory(new File(this.field.getNodeMetaHandler().getSavePath()));
        }
        if ((i = chooser.showOpenDialog(null)) == 0) {
            ImageIcon icon = new ImageIcon(chooser.getSelectedFile().getAbsolutePath());
            this.field.loadPicture(icon);
            this.field.setHAS_PICTURE(true);
            this.field.setCenter_picX(icon.getIconWidth() / 2);
            this.field.setCenter_picY(icon.getIconHeight() / 2);
        }
        this.toFront();
    }

    private void jB_SpeichernActionPerformed(ActionEvent evt) {
        this.jMI_SpeichernActionPerformed(evt);
    }

    private void jB_NeuActionPerformed(ActionEvent evt) {
        this.jMI_NeuActionPerformed(evt);
    }

    private void jB_EgopersonActionPerformed(ActionEvent evt) {
        this.jMI_EgoPersonSetzenActionPerformed(evt);
    }

    private void jB_BeziehungenActionPerformed(ActionEvent evt) {
        this.jMI_BeziehungCheckActionPerformed(evt);
    }

    private void jB_VernkErstActionPerformed(ActionEvent evt) {
        this.jMI_Clusterverk_erstellenActionPerformed(evt);
    }

    private void jB_VerkLoeschActionPerformed(ActionEvent evt) {
        this.jMI_Clusterverk_loeschenActionPerformed(evt);
    }

    private void jB_LoadActionPerformed(ActionEvent evt) {
        this.jMI_LadenActionPerformed(evt);
    }

    private void jB_PaketspeicherungActionPerformed(ActionEvent evt) {
        this.jMI_PaketspeicherungActionPerformed(evt);
    }

    private void jTFFieldNrKeyTyped(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            String a = this.jTFFieldNr.getText();
            try {
                Integer number = new Integer(a);
                this.field.getNodeMetaHandler().setPos(number - 1);
                this.field.repaint();
            }
            catch (NumberFormatException nfe) {
                this.jTFFieldNr.setText("" + (this.field.getNodeMetaHandler().getPos() + 1));
            }
        }
    }

    private void jTFFieldNrKeyPressed(KeyEvent evt) {
        this.jTFFieldNrKeyTyped(evt);
    }

    private void jMI_AnonymisierenActionPerformed(ActionEvent evt) {
        this.ANONYM = true;
        for (AbkKatalog k : this.field.getNodeMetaHandler().getAbkkat()) {
            k.setnumUsed(1);
        }
        block1: for (Node n : this.field.getNodeMetaHandler().getNodes()) {
            for (AbkKatalog k : this.field.getNodeMetaHandler().getAbkkat()) {
                if (!k.getAbk().equals(n.getAnonAbk().trim())) continue;
                n.setAnonName(k.getAusdruck() + " " + k.getNumUsed());
                k.setnumUsed(k.getNumUsed() + 1);
                continue block1;
            }
        }
        this.jMI_SpeichernUnterActionPerformed(evt);
        this.ANONYM = false;
        this.toFront();
    }

    private void jMI_PersonenKopierenActionPerformed(ActionEvent evt) {
        int kartennr = -1;
        int nh_id_cur = -1;
        int nh_id_prev = -1;
        int lnr = -1;
        this.list_pos = new LinkedList<Position>();
        this.list_link = new HashSet<Link>(0);
        boolean HAS_NODE_ON_FIELD = false;
        kartennr = this.field.getNodeMetaHandler().getPos() - 1;
        if (kartennr < 0) {
            JOptionPane.showMessageDialog(this, this.getTranslation("dialogMsgNoPreviousCardText"), this.getTranslation("dialogMsgNoPreviousCardTitle"), 0);
            return;
        }
        nh_id_cur = this.field.getNodeMetaHandler().getNhandler().get(kartennr + 1).getNh_id();
        nh_id_prev = this.field.getNodeMetaHandler().getNhandler().get(kartennr).getNh_id();
        for (Position p : this.field.getNodeMetaHandler().getPositions()) {
            if (p.getId_nhandler() != nh_id_cur) continue;
            HAS_NODE_ON_FIELD = true;
            break;
        }
        if (HAS_NODE_ON_FIELD) {
            JOptionPane.showMessageDialog(this, this.getTranslation("dialogMsgPersonsAvailableText"), this.getTranslation("dialogMsgPersonsAvailableTitle"), 0);
            return;
        }
        for (Position p : this.field.getNodeMetaHandler().getPositions()) {
            if (p.getId_nhandler() != nh_id_prev) continue;
            Position position = new Position(this.field.getNodeMetaHandler(), nh_id_cur, p.getN(), p.getPosX(), p.getPosY(), p.getKante());
            this.list_pos.add(position);
        }
        if (this.list_pos.size() == 0) {
            JOptionPane.showMessageDialog(this, this.getTranslation("dialogMsgNoPreviousCardPersonText"), this.getTranslation("dialogMsgNoPreviousCardPersonTitle"), 0);
            return;
        }
        for (Link l : this.field.getNodeMetaHandler().getLinks()) {
            Position p1 = null;
            Position p2 = null;
            if (l.getId_nhandler() != nh_id_prev) continue;
            for (Position p : this.list_pos) {
                if (p.getN().getID() == l.getPos_1().getN().getID()) {
                    p1 = p;
                }
                if (p.getN().getID() != l.getPos_2().getN().getID()) continue;
                p2 = p;
            }
            if (p1 != null && p2 != null) {
                Link link = new Link(nh_id_cur, p1, p2);
                this.list_link.add(link);
            } else {
                System.out.println("BAA02: found not a link");
            }
            p2 = null;
            p1 = null;
        }
        this.setKOPY_FIELD(true);
        this.pos_copy_person = 0;
    }

    private void jMI_DeleteFieldActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, this.getTranslation("dialogMsgDeleteLastCardText"), this.getTranslation("dialogMsgDeleteLastCardTitle"), 0) == 1) {
            return;
        }
        LinkedList<Position> posi = new LinkedList<Position>();
        HashSet<Link> linki = new HashSet<Link>(0);
        boolean CAN_DELETE = true;
        int nh_IDfield_last = this.field.getNodeMetaHandler().getNhandler().get(this.field.getNodeMetaHandler().getNhandler().size() - 1).getNh_id();
        for (Position p : this.field.getNodeMetaHandler().getPositions()) {
            if (p.getId_nhandler() != nh_IDfield_last) continue;
            posi.add(p);
        }
        for (Link l : this.field.getNodeMetaHandler().getLinks()) {
            if (l.getId_nhandler() != nh_IDfield_last) continue;
            linki.add(l);
        }
        if (posi.size() > 0) {
            for (Position p : posi) {
                int id_node = p.getN().getID();
                this.field.getNodeMetaHandler().getPositions().remove(p);
                for (Position p2 : this.field.getNodeMetaHandler().getPositions()) {
                    if (p2.getN().getID() != id_node || p2.getId_nhandler() == nh_IDfield_last) continue;
                    CAN_DELETE = false;
                    break;
                }
                if (CAN_DELETE) {
                    this.field.getNodeMetaHandler().remove(id_node, nh_IDfield_last);
                }
                CAN_DELETE = false;
            }
        }
        if (linki.size() > 0) {
            for (Link l : linki) {
                this.field.getNodeMetaHandler().getLinks().remove(l);
            }
        }
        this.field.getNodeMetaHandler().removeLastNodeHandler();
        this.jLFieldMax.setText("/" + this.field.getNodeMetaHandler().numNodeHandler());
        this.jTFFieldNr.setText("" + (this.field.getNodeMetaHandler().getPos() + 1));
        this.repaint();
    }

    private void jMIZeichne_KreiseActionPerformed(ActionEvent evt) {
        this.field.setDRAW_CIRCLES(!this.field.isDRAW_CIRCLES());
        this.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new NetworkField().setVisible(true);
            }
        });
    }

    private void doSaveError() {
        this.doSaveError(this.getTranslation("dialogMsgSavingErrorText"), this.getTranslation("dialogMsgSavingErrorTitle"));
    }

    private void doSaveError(String message, String titel) {
        JOptionPane.showMessageDialog(null, message, titel, 0);
    }

    private boolean loadField() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter2 = new FileNameExtensionFilter("Network-File", "nwk");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text File", "txt");
        if (this.field.getNodeMetaHandler().getSavePath() == null ? "" != null : !this.field.getNodeMetaHandler().getSavePath().equals("")) {
            chooser.setCurrentDirectory(new File(this.field.getNodeMetaHandler().getSavePath()));
        }
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter2);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            try {
                this.field.getNodeMetaHandler().load(chooser.getSelectedFile());
                this.jLFieldMax.setText("/" + this.field.getNodeMetaHandler().getNhandler().size());
                return true;
            }
            catch (IOException ioex) {
                this.doSaveError();
            }
            catch (ParseIntException piex) {
                this.doSaveError();
            }
        }
        return false;
    }

    public Field getField() {
        return this.field;
    }

    private void setHAS_NO_EGOPERS(boolean b) {
        this.HAS_NO_EGOPERS = b;
        this.field.setFIRST_START(b);
        if (b) {
            this.jMI_Speichern.setEnabled(false);
            this.jMI_SpeichernUnter.setEnabled(false);
            this.jMI_EgoPersonSetzen.setEnabled(false);
            this.jMI_jpgGrafikExp.setEnabled(false);
            this.jMI_VektorgrafikExp.setEnabled(false);
            this.jMI_AnalyseStarten.setEnabled(false);
            this.jMI_Clusterverk_erstellen.setEnabled(false);
            this.jMI_Clusterverk_loeschen.setEnabled(false);
            this.jMI_BeziehungCheck.setEnabled(false);
            this.jMI_Paketspeicherung.setEnabled(false);
            this.jMI_Beenden.setEnabled(false);
            this.jMI_Anonymisieren.setEnabled(false);
            this.jMI_BildLaden.setEnabled(false);
            this.jMI_PersonenKopieren.setEnabled(false);
            this.jMI_jpgGrafikExp.setEnabled(false);
            this.jMI_VektorgrafikExp.setEnabled(false);
            this.jMI_AnalyseStarten.setEnabled(false);
            this.jMenu1.setEnabled(false);
            this.jMExportJPG.setEnabled(false);
            this.jMExportSVG.setEnabled(false);
            this.remove(this.jPanel1);
            this.jB_Beziehungen.setEnabled(false);
            this.jB_Egoperson.setEnabled(false);
            this.jB_Paketspeicherung.setEnabled(false);
            this.jB_Speichern.setEnabled(false);
            this.jB_VerkLoesch.setEnabled(false);
            this.jB_VernkErst.setEnabled(false);
        } else {
            this.jMI_Speichern.setEnabled(true);
            this.jMI_SpeichernUnter.setEnabled(true);
            this.jMI_EgoPersonSetzen.setEnabled(true);
            this.jMI_jpgGrafikExp.setEnabled(true);
            this.jMI_VektorgrafikExp.setEnabled(true);
            this.jMI_AnalyseStarten.setEnabled(true);
            this.jMI_Clusterverk_erstellen.setEnabled(true);
            this.jMI_Clusterverk_loeschen.setEnabled(true);
            this.jMI_BeziehungCheck.setEnabled(true);
            this.jMI_Paketspeicherung.setEnabled(true);
            this.jMI_Beenden.setEnabled(true);
            this.jMI_Anonymisieren.setEnabled(true);
            this.jMI_BildLaden.setEnabled(true);
            this.jMI_PersonenKopieren.setEnabled(true);
            this.jMI_jpgGrafikExp.setEnabled(true);
            this.jMI_VektorgrafikExp.setEnabled(true);
            this.jMI_AnalyseStarten.setEnabled(true);
            this.jMenu1.setEnabled(true);
            this.jMExportJPG.setEnabled(true);
            this.jMExportSVG.setEnabled(true);
            this.add((Component)this.jPanel1, "South");
            this.jB_Beziehungen.setEnabled(true);
            this.jB_Egoperson.setEnabled(true);
            this.jB_Paketspeicherung.setEnabled(true);
            this.jB_Speichern.setEnabled(true);
            this.jB_VerkLoesch.setEnabled(true);
            this.jB_VernkErst.setEnabled(true);
            this.setSize(this.getWidth() + 1, this.getHeight() + 1);
            this.setSize(this.getWidth() - 1, this.getHeight() - 1);
        }
        this.field.repaint();
    }

    private void checkEgo_person() {
        if (this.field.getNodeMetaHandler().hasEgo_person()) {
            this.setHAS_NO_EGOPERS(false);
        } else {
            this.setHAS_NO_EGOPERS(true);
        }
    }

    public void resize() {
        int h;
        int w = this.getWidth();
        if (w < (h = this.getHeight())) {
            this.setSize(w, w);
        } else if (h < w) {
            this.setSize(h, h);
        }
    }

    public boolean isANONYM() {
        return this.ANONYM;
    }

    public void setKOPY_FIELD(boolean b) {
        this.field.setKOPY_FIELD(b);
        if (b) {
            this.jMI_Speichern.setEnabled(false);
            this.jMI_SpeichernUnter.setEnabled(false);
            this.jMI_EgoPersonSetzen.setEnabled(false);
            this.jMI_jpgGrafikExp.setEnabled(false);
            this.jMI_VektorgrafikExp.setEnabled(false);
            this.jMI_AnalyseStarten.setEnabled(false);
            this.jMI_Clusterverk_erstellen.setEnabled(false);
            this.jMI_Clusterverk_loeschen.setEnabled(false);
            this.jMI_BeziehungCheck.setEnabled(false);
            this.jMI_Neu.setEnabled(false);
            this.jMI_Laden.setEnabled(false);
            this.jMI_Paketspeicherung.setEnabled(false);
            this.jMI_Beenden.setEnabled(false);
            this.jMI_Anonymisieren.setEnabled(false);
            this.jMI_BildLaden.setEnabled(false);
            this.jMI_PersonenKopieren.setEnabled(false);
            this.jMI_jpgGrafikExp.setEnabled(false);
            this.jMI_VektorgrafikExp.setEnabled(false);
            this.jMI_AnalyseStarten.setEnabled(false);
            this.jMI_Info.setEnabled(false);
            this.jMI_About.setEnabled(false);
            this.jMenu1.setEnabled(false);
            this.jMExportJPG.setEnabled(false);
            this.jMExportSVG.setEnabled(false);
            this.remove(this.jPanel1);
            this.remove(this.jToolBar1);
            this.jB_Beziehungen.setEnabled(false);
            this.jB_Egoperson.setEnabled(false);
            this.jB_Paketspeicherung.setEnabled(false);
            this.jB_Speichern.setEnabled(false);
            this.jB_VerkLoesch.setEnabled(false);
            this.jB_VernkErst.setEnabled(false);
        } else {
            this.jMI_Speichern.setEnabled(true);
            this.jMI_SpeichernUnter.setEnabled(true);
            this.jMI_EgoPersonSetzen.setEnabled(true);
            this.jMI_jpgGrafikExp.setEnabled(true);
            this.jMI_VektorgrafikExp.setEnabled(true);
            this.jMI_AnalyseStarten.setEnabled(true);
            this.jMI_Clusterverk_erstellen.setEnabled(true);
            this.jMI_Clusterverk_loeschen.setEnabled(true);
            this.jMI_BeziehungCheck.setEnabled(true);
            this.jMI_Neu.setEnabled(true);
            this.jMI_Laden.setEnabled(true);
            this.jMI_Paketspeicherung.setEnabled(true);
            this.jMI_Beenden.setEnabled(true);
            this.jMI_Anonymisieren.setEnabled(true);
            this.jMI_BildLaden.setEnabled(true);
            this.jMI_PersonenKopieren.setEnabled(true);
            this.jMI_jpgGrafikExp.setEnabled(true);
            this.jMI_VektorgrafikExp.setEnabled(true);
            this.jMI_AnalyseStarten.setEnabled(true);
            this.jMI_Info.setEnabled(true);
            this.jMI_About.setEnabled(true);
            this.jMenu1.setEnabled(true);
            this.jMExportJPG.setEnabled(true);
            this.jMExportSVG.setEnabled(true);
            this.add(this.jPanel1);
            this.add(this.jToolBar1);
            this.jB_Beziehungen.setEnabled(true);
            this.jB_Egoperson.setEnabled(true);
            this.jB_Paketspeicherung.setEnabled(true);
            this.jB_Speichern.setEnabled(true);
            this.jB_VerkLoesch.setEnabled(true);
            this.jB_VernkErst.setEnabled(true);
        }
        this.repaint();
    }

    public int getPos_copy_person() {
        return this.pos_copy_person;
    }

    public void setPos_copy_person(int pos_copy_person) {
        this.pos_copy_person = pos_copy_person;
    }

    public Collection<Link> getList_link() {
        return this.list_link;
    }

    public void setList_link(Collection<Link> list_link) {
        this.list_link = list_link;
    }

    public List<Position> getList_pos() {
        return this.list_pos;
    }

    public void setList_pos(List<Position> list_pos) {
        this.list_pos = list_pos;
    }

    private void initLanguage() {
        this.languageChangedEvent = new LanguageChangedEvent();
        this.languageChangedEvent.addListener(this);
        this.languageHandler = new LanguageHandler();
        File file = new File(".\\language");
        this.createLanguageDirIfNotExists(file);
        this.loadFilesInLanguageFodler(file);
        this.languageHandler.addLanguage(this.getClass().getResourceAsStream("/language/languageEN.xml"));
        this.languageHandler.addLanguage(this.getClass().getResourceAsStream("/language/languageDE.xml"));
    }

    private void loadFilesInLanguageFodler(File file) throws HeadlessException {
        File[] children;
        for (File f : children = file.listFiles()) {
            if (!f.getName().endsWith(".xml")) continue;
            try {
                this.languageHandler.addLanguage(new FileInputStream(f));
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "Couldn't load file '" + f.getName());
                ex.printStackTrace();
            }
        }
    }

    private void createLanguageDirIfNotExists(File file) {
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public String getTranslation(String id) {
        return this.languageHandler.getTranslation(id);
    }

    @Override
    public void languageHasChanged() {
        this.jMAbout.setText(this.languageHandler.getTranslation("menuItemAbout"));
        this.jMDatei.setText(this.languageHandler.getTranslation("menuItemData"));
        this.jMIZeichne_Kreise.setText(this.languageHandler.getTranslation("menuItemAdministrateShowHorizons"));
        this.jMI_About.setText(this.languageHandler.getTranslation("menuItemAbout"));
        this.jMI_AnalyeAll.setText(this.languageHandler.getTranslation("menuItemAdministrateExportAllCards"));
        this.jMI_AnalyseStarten.setText(this.languageHandler.getTranslation("menuItemAdministrateExportActualCard"));
        this.jMI_Anonymisieren.setText(this.languageHandler.getTranslation("menuItemAdministrateAnonymization"));
        this.jMI_Beenden.setText(this.languageHandler.getTranslation("menuItemDataClose"));
        this.jMI_BeziehungCheck.setText(this.languageHandler.getTranslation("menuItemAdministrateManageRelation"));
        this.jMI_BildLaden.setText(this.languageHandler.getTranslation("menuItemAdministrateLoadPicture"));
        this.jMI_Clusterverk_erstellen.setText(this.languageHandler.getTranslation("menuItemAdministrateCreateClusterRelation"));
        this.jMI_Clusterverk_loeschen.setText(this.languageHandler.getTranslation("menuItemAdministrateDeleteClusterRelation"));
        this.jMI_DeleteField.setText(this.languageHandler.getTranslation("menuItemAdministrateDeleteLastCard"));
        this.jMI_EgoPersonSetzen.setText(this.languageHandler.getTranslation("menuItemAdministrateClient"));
        this.jMI_Info.setText(this.languageHandler.getTranslation("menuItemAboutInfo"));
        this.jMI_Laden.setText(this.languageHandler.getTranslation("menuItemDataLoad"));
        this.jMI_Neu.setText(this.languageHandler.getTranslation("menuItemDataNew"));
        this.jMI_Paketspeicherung.setText(this.languageHandler.getTranslation("menuItemDataSavePackage"));
        this.jMI_PersonenKopieren.setText(this.languageHandler.getTranslation("menuItemAdministrateCopyPersonFromFormerCard"));
        this.jMI_Speichern.setText(this.languageHandler.getTranslation("menuItemDataSave"));
        this.jMI_SpeichernUnter.setText(this.languageHandler.getTranslation("menuItemDataSaveAs"));
        this.jMI_VektorgrafikExp.setText(this.languageHandler.getTranslation("menuItemAdministrateExportActualCard"));
        this.jMI_VektorgrafikExpAlles.setText(this.languageHandler.getTranslation("menuItemAdministrateExportAllCards"));
        this.jMI_jpgGrafikExp.setText(this.languageHandler.getTranslation("menuItemAdministrateExportActualCard"));
        this.jMI_jpgGrafikExpAlles.setText(this.languageHandler.getTranslation("menuItemAdministrateExportAllCards"));
        this.jMLanguage.setText("Language (" + this.languageHandler.getTranslation("menuItemLanguage") + ")");
        this.jMVerwalten.setText(this.languageHandler.getTranslation("menuItemAdministrate"));
        this.jMExportJPG.setText(this.languageHandler.getTranslation("menuItemAdministrateExportJPG"));
        this.jMExportSVG.setText(this.languageHandler.getTranslation("menuItemAdministrateExportSVG"));
        this.jLKarte.setText(this.languageHandler.getTranslation("labelFooterCards"));
        this.jB_Neu.setToolTipText(this.getTranslation("menuItemDataNew"));
        this.jB_Load.setToolTipText(this.getTranslation("menuItemDataLoad"));
        this.jB_Speichern.setToolTipText(this.getTranslation("menuItemDataSave"));
        this.jB_Paketspeicherung.setToolTipText(this.getTranslation("menuItemDataSavePackage"));
        this.jB_Egoperson.setToolTipText(this.getTranslation("menuItemAdministrateClient"));
        this.jB_Beziehungen.setToolTipText(this.getTranslation("menuItemAdministrateManageRelation"));
        this.jB_VernkErst.setToolTipText(this.getTranslation("menuItemAdministrateCreateClusterRelation"));
        this.jB_VerkLoesch.setToolTipText(this.getTranslation("menuItemAdministrateDeleteClusterRelation"));
        this.field.getNodeMetaHandler().loadAbkKat();
        System.out.println("length positions: " + this.field.getNodeMetaHandler().getPositions().size());
        for (Position p : this.field.getNodeMetaHandler().getPositions()) {
            Node n = p.getN();
            String abkAlt = n.getAnonForSaving();
            System.out.println("abkAlt = " + abkAlt);
            for (AbkKatalog k : this.field.getNodeMetaHandler().getAbkkat()) {
                if (!abkAlt.equals(k.getAbkForSaving())) continue;
                System.out.println("old abk: " + abkAlt + ". New one: " + k.getAbk());
                n.setAnonAbk(k.getAbk());
                n.setAnonName(k.getAusdruck());
            }
        }
        this.repaint();
    }
}

