/*
 * Decompiled with CFR 0.152.
 */
package netzwerkkarte;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import netzwerk.exception.ParseIntException;
import netzwerkkarte.Field;
import nodehandler.AbkKatalog;
import nodehandler.Link;
import nodehandler.NetworkAnalysis;
import nodehandler.Node;
import nodehandler.NodeHandler;
import nodehandler.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMetaHandler {
    private List<Node> nodes;
    private Collection<Link> links;
    private int id = 100;
    private String ego_person = "";
    private int alter = 0;
    private String ego_person_info = "";
    private int nh_id = 1000;
    private int pos = 0;
    private String path = "";
    private List<Position> positions = new LinkedList<Position>();
    private List<NodeHandler> nhandler = new LinkedList<NodeHandler>();
    private List<AbkKatalog> abkkat = new LinkedList<AbkKatalog>();
    private Field field;

    public NodeMetaHandler(Field parent) {
        this.field = parent;
        this.nh_id = 1000;
        NodeHandler nh = new NodeHandler(this);
        nh.setNH_id(this.nh_id);
        ++this.nh_id;
        this.nhandler.add(nh);
        this.nodes = new LinkedList<Node>();
        this.links = new HashSet<Link>(0);
        this.loadAbkKat();
    }

    public NodeMetaHandler(Field parent, String ego_person, int alter) {
        this(parent);
        this.ego_person = ego_person;
        this.alter = alter;
    }

    public NodeHandler newNodeHandler() {
        NodeHandler nh = new NodeHandler(this);
        nh.setNH_id(this.nh_id);
        ++this.nh_id;
        this.nhandler.add(nh);
        this.pos = this.nhandler.size() - 1;
        return nh;
    }

    public NodeHandler nextNodeHandler() {
        if (this.pos + 1 == this.nhandler.size()) {
            return this.nhandler.get(this.pos);
        }
        ++this.pos;
        return this.nhandler.get(this.pos);
    }

    public NodeHandler prevNodeHandler() {
        if (this.pos - 1 < 0) {
            return this.nhandler.get(0);
        }
        --this.pos;
        return this.nhandler.get(this.pos);
    }

    public NodeHandler setNodeHandler(int number) {
        if (number < 0) {
            this.pos = 0;
            return this.nhandler.get(0);
        }
        if (number >= this.nhandler.size()) {
            this.pos = this.nhandler.size() - 1;
            return this.nhandler.get(this.nhandler.size() - 1);
        }
        this.pos = number;
        return this.nhandler.get(number);
    }

    public NodeHandler firstNodeHandler() {
        return this.nhandler.get(0);
    }

    public NodeHandler lastNodeHandler() {
        return this.nhandler.get(this.nhandler.size() - 1);
    }

    public int numNodeHandler() {
        return this.nhandler.size();
    }

    public void removeLastNodeHandler() {
        this.nhandler.remove(this.nhandler.size() - 1);
        if (this.nhandler.size() <= this.pos) {
            --this.pos;
        }
    }

    public NodeHandler getNodeHandler() {
        return this.nhandler.get(this.pos);
    }

    public Position add(double posX, double posY, String name) {
        Node n = new Node(this.id, name);
        Position p = new Position(this, this.nhandler.get(this.pos).getNh_id(), n, posX, posY, 1);
        this.nodes.add(n);
        this.positions.add(p);
        ++this.id;
        return p;
    }

    public void analyse(File file, boolean anal_all) throws IOException {
        NetworkAnalysis[] netanal;
        if (!file.getName().toUpperCase().endsWith(".CSV")) {
            file = new File(file.getAbsolutePath() + ".csv");
        }
        BufferedWriter bwrite = new BufferedWriter(new FileWriter(file));
        if (anal_all) {
            netanal = new NetworkAnalysis[this.nhandler.size()];
            for (int i = 0; i < this.nhandler.size(); ++i) {
                netanal[i] = new NetworkAnalysis(this.positions, this.links, this.nhandler.get(i).getNh_id());
                netanal[i].analyse();
            }
        } else {
            netanal = new NetworkAnalysis[]{new NetworkAnalysis(this.positions, this.links, this.getNodeHandler().getNh_id())};
            netanal[0].analyse();
        }
        bwrite.write(this.getTranslation("analyseFrom") + ":;" + this.getEgo_person());
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseCreationDate") + ":;");
        if (anal_all) {
            for (NodeHandler nh : this.nhandler) {
                bwrite.write(nh.getErstelldatum() + ";");
            }
        } else {
            bwrite.write(this.getNodeHandler().getErstelldatum());
        }
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseMaleContacts") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getMale() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseFemaleContacts") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getFemale() + ";");
        }
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeAll") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_gesamt() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeFamily") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_familie() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeProf") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_prof_beziehung() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeColleagues") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_beruf() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeFriends") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_freunde() + ";");
        }
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeCircle3") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_kreis3() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeCircle32") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_kreis32() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseNetworkSizeCircle321") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNetwork_kreis321() + ";");
        }
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseRelationWeight") + ":");
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseRelationWeightFamily") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNaehensumme_familie() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseRelationWeightProf") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNaehensumme_prof_beziehung() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseRelationWeightColleagues") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNaehensumme_beruf() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseRelationWeightFriends") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getNaehensumme_freunde() + ";");
        }
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityAll") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_gesamt()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityCircle3") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_kreis3()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityCircle32") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_kreis32()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityCircle321") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_kreis321()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityFamily") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_familie()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityProf") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_prof_beziehung()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityColleagues") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_beruf()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseDensityFriends") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(String.format("%4.3f", nal.getDichte_freunde()) + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseBridges") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getBruecken_num() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseBridgepersons") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getBruecken_num_personen() + ";");
        }
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write(this.getTranslation("analysePeronsWithNoConnections") + ":;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getPerson_edge_zero() + ";");
        }
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseCenterCalculation") + ":");
        bwrite.newLine();
        bwrite.write("Anzahl Personen ohne Beziehungen:;");
        for (NetworkAnalysis nal : netanal) {
            bwrite.write(nal.getPerson_without_links() + ";");
        }
        bwrite.newLine();
        bwrite.write(this.getTranslation("analyseStar") + ":;");
        int max = 0;
        for (NetworkAnalysis nal : netanal) {
            if (nal.getzentralpersons_list().size() <= max) continue;
            max = nal.getzentralpersons_list().size();
        }
        for (int i = 0; i < max; ++i) {
            for (NetworkAnalysis nal : netanal) {
                if (nal.getzentralpersons_list().size() <= i) {
                    bwrite.write(";");
                    continue;
                }
                bwrite.write(nal.getzentralpersons_list().get(i).getN().getName() + ";");
            }
            bwrite.newLine();
            bwrite.write(";");
        }
        bwrite.close();
    }

    public void clear() {
        this.nodes.clear();
        this.links.clear();
        this.nh_id = 1000;
        this.pos = 0;
        this.nhandler.clear();
        this.id = 100;
        this.positions.clear();
        this.ego_person = "";
        this.alter = 0;
        this.path = "";
    }

    public boolean deleteLink(Position pos_1, Position pos_2) {
        Link link = new Link(this.nhandler.get(this.pos).getNh_id(), pos_1, pos_2);
        return this.links.remove(link);
    }

    public void draw(Graphics g, int width, int height, boolean anonym) {
        Color color = g.getColor();
        g.setColor(Color.BLACK);
        if (this.ego_person != null && !this.ego_person.equals("")) {
            Font f = g.getFont();
            g.setFont(new Font("Dialog", 0, 12));
            g.drawString(this.field.getNetfield().getTranslation("fieldNetworkFrom"), (int)(0.52 * (double)width), 14);
            g.drawString(this.ego_person + " (" + this.alter + "a), " + this.nhandler.get(this.pos).getErstelldatum(), (int)(0.52 * (double)width), 28);
            g.setFont(f);
        }
        int radius = (width + height) / 2 / 120;
        Node.setRadius(radius);
        for (Position n : this.positions) {
            if (n.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
            n.drawLine(g, width, height);
        }
        for (Link l : this.links) {
            if (l.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
            l.draw(g, width, height);
        }
        for (Position n : this.positions) {
            if (n.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
            n.drawCircle(g, width, height);
            n.drawString(g, width, height, anonym);
        }
        g.setColor(color);
    }

    public void drawOnLabel(Graphics g, int width, int height, boolean anonym, int centerX, int centerY) {
        for (Position n : this.positions) {
            if (n.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
            n.drawLineOnLabel(g, width, height, centerX, centerY);
        }
        for (Link l : this.links) {
            if (l.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
            l.drawOnLabel(g, centerX, centerY);
        }
        for (Position n : this.positions) {
            if (n.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
            n.drawCircleOnLabel(g, width, height, centerX, centerY);
            n.drawStringOnLabel(g, width, height, anonym, centerX, centerY);
        }
    }

    public String getErstelldatum() {
        return this.nhandler.get(this.pos).getErstelldatum();
    }

    public Link[] getLinkbyArray() {
        Object[] link_list = this.links.toArray(new Link[0]);
        Arrays.sort(link_list);
        return link_list;
    }

    public Collection<Link> getLinks() {
        return this.links;
    }

    public Node[] getNodelistbyArray() {
        Object[] node_list = this.nodes.toArray(new Node[0]);
        Arrays.sort(node_list);
        return node_list;
    }

    public Node getNodeByID(int id) {
        for (Node n : this.nodes) {
            if (n.getID() != id) continue;
            return n;
        }
        return null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public String getSavePath() {
        return this.path;
    }

    public boolean hasEgo_person() {
        return this.ego_person != null && this.ego_person.length() != 0;
    }

    public boolean hasLink(Position pos_1, Position pos_2) {
        if (pos_1 == null || pos_2 == null) {
            return false;
        }
        if (pos_1.getN().getID() > pos_2.getN().getID()) {
            Position n = pos_2;
            pos_2 = pos_1;
            pos_1 = n;
        }
        for (Link l : this.links) {
            if (l.getNode_1().getID() != pos_1.getN().getID() || l.getNode_2().getID() != pos_2.getN().getID()) continue;
            return true;
        }
        return false;
    }

    public Position intersect(double posX, double posY) {
        for (Position p : this.positions) {
            if (p.getId_nhandler() != this.nhandler.get(this.pos).getNh_id() || !(p.getPosX() + 0.015 >= posX) || !(p.getPosX() - 0.015 <= posX) || !(p.getPosY() + 0.015 >= posY) || !(p.getPosY() - 0.015 <= posY)) continue;
            return p;
        }
        return null;
    }

    public boolean isKante2allowed() {
        int count = 0;
        int feld_id = this.nhandler.get(this.pos).getNh_id();
        for (Position p : this.positions) {
            if (p.getId_nhandler() == feld_id && p.getKante() == 2 && ++count == 2) break;
        }
        return count < 2;
    }

    public void load(File file) throws FileNotFoundException, ParseIntException {
        this.clear();
        this.path = file.getAbsolutePath();
        BufferedReader bread = null;
        String info = "";
        Object node_1 = null;
        Object link = null;
        Object nh = null;
        Object po = null;
        Object po2 = null;
        boolean light = false;
        if (file.getName().toUpperCase().endsWith("TXT")) {
            light = true;
        }
        try {
            bread = new BufferedReader(new FileReader(file));
            if (!light) {
                while ((info = bread.readLine()) != null) {
                    String[] infoarray = info.split(";");
                    if (infoarray[0].equals("N")) {
                        this.loadNodeElement(infoarray);
                        continue;
                    }
                    if (infoarray[0].equals("L")) {
                        this.loadLinkElement(infoarray);
                        continue;
                    }
                    if (infoarray[0].equals("E")) {
                        this.loadEgoPerson(infoarray);
                        continue;
                    }
                    if (infoarray[0].equals("F")) {
                        this.loadFieldElement(infoarray);
                        continue;
                    }
                    if (!infoarray[0].equals("P")) continue;
                    this.loadPositionElement(infoarray);
                }
            } else {
                this.loadLightVersion(bread);
            }
        }
        catch (IOException ex) {
        }
        catch (NumberFormatException nex) {
            throw new ParseIntException();
        }
        finally {
            try {
                bread.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void loadLightVersion(BufferedReader bread) throws IOException, NumberFormatException {
        String info;
        if (this.nhandler.size() == 0) {
            this.newNodeHandler();
        }
        while ((info = bread.readLine()) != null) {
            Position po;
            String[] infoarray = info.split(";");
            if (infoarray[0].equals("N")) {
                Node node_1 = new Node(new Integer(infoarray[1]), infoarray[2]);
                if (infoarray.length >= 7) {
                    if (infoarray[6].equals("m")) {
                        node_1.setMaennlich();
                    } else {
                        node_1.setWeiblich();
                    }
                } else {
                    node_1.setMaennlich();
                }
                this.nodes.add(node_1);
                this.id = new Integer(infoarray[1]) + 1;
                po = new Position(this, this.getNodeHandler().getNh_id(), node_1, new Double(infoarray[4]), new Double(infoarray[5]), new Integer(infoarray[3]));
                this.positions.add(po);
                continue;
            }
            if (infoarray[0].equals("L")) {
                po = this.getPositionByNodeInField(new Integer(infoarray[1]));
                Position po2 = this.getPositionByNodeInField(new Integer(infoarray[2]));
                if (po == null || po2 == null) continue;
                Link link = new Link(this.getNodeHandler().getNh_id(), po, po2);
                this.links.add(link);
                continue;
            }
            if (!infoarray[0].equals("E")) continue;
            this.ego_person = infoarray[1];
            this.alter = new Integer(infoarray[2]);
        }
    }

    private void loadPositionElement(String[] infoarray) throws NumberFormatException {
        Position po = new Position(this, new Integer(infoarray[1]), this.getNodeByID(new Integer(infoarray[2])), new Double(infoarray[3]), new Double(infoarray[4]), new Integer(infoarray[5]));
        this.positions.add(po);
    }

    private void loadFieldElement(String[] infoarray) throws NumberFormatException {
        NodeHandler nh = new NodeHandler(this);
        int infor = new Integer(infoarray[1]);
        nh.setNH_id(infor);
        nh.setErstelldatum(infoarray[2]);
        this.nhandler.add(nh);
        if (infor >= this.nh_id) {
            this.nh_id = ++infor;
        }
    }

    private void loadEgoPerson(String[] infoarray) throws NumberFormatException {
        this.ego_person = infoarray[1];
        this.alter = new Integer(infoarray[2]);
        if (infoarray.length == 4) {
            infoarray[3] = infoarray[3].replaceAll("_sk_", ";");
            this.ego_person_info = infoarray[3].replaceAll("_lb_", "\n");
        }
    }

    private void loadLinkElement(String[] infoarray) throws NumberFormatException {
        int indent = new Integer(infoarray[1]);
        Position po = this.getPositionByNodeInField(new Integer(infoarray[2]), indent);
        Position po2 = this.getPositionByNodeInField(new Integer(infoarray[3]), indent);
        if (po != null && po2 != null) {
            Link link = new Link(indent, po, po2);
            this.links.add(link);
        }
    }

    private void loadNodeElement(String[] infoarray) throws NumberFormatException {
        Node node_1 = new Node(new Integer(infoarray[1]), infoarray[2]);
        if (infoarray[3].equals("m")) {
            node_1.setMaennlich();
        } else {
            node_1.setWeiblich();
        }
        this.nodes.add(node_1);
        if (infoarray.length > 4) {
            String abkForSaving = infoarray[4];
            for (AbkKatalog k : this.field.getNodeMetaHandler().getAbkkat()) {
                if (!k.getAbkForSaving().equals(abkForSaving)) continue;
                node_1.setAnonAbk(k.getAbk());
                node_1.setAnonForSaving(abkForSaving);
            }
            if (infoarray.length > 5) {
                String s = infoarray[5];
                s = s.replaceAll("_sk_", ";");
                s = s.replaceAll("_lb_", "\n");
                node_1.setNotiz(s);
            }
        } else {
            node_1.setAnonAbk("U");
        }
        this.id = new Integer(infoarray[1]) + 1;
    }

    public void newLink(Position pos_1, Position pos_2) {
        Link link = new Link(this.nhandler.get(this.pos).getNh_id(), pos_1, pos_2);
        this.links.add(link);
    }

    public Position remove(int id_node, int id_nhandler) {
        Node n = null;
        Position posi = null;
        for (Position p : this.positions) {
            if (p.getId_nhandler() != id_nhandler || p.getN().getID() != id_node) continue;
            posi = p;
            n = p.getN();
            break;
        }
        this.positions.remove(posi);
        if (posi != null) {
            HashSet<Link> lin = new HashSet<Link>(0);
            for (Link l : this.links) {
                if (l.getId_nhandler() != id_nhandler || l.getNode_1().getID() != id_node && l.getNode_2().getID() != id_node) continue;
                lin.add(l);
            }
            if (lin.size() > 0) {
                for (Link li : lin) {
                    this.links.remove(li);
                }
            }
            return posi;
        }
        return null;
    }

    public void save() throws IOException {
        if (this.path.equals("")) {
            throw new IOException("Kein Speicherpfad angegeben.");
        }
        this.save(new File(this.path));
    }

    public void save(File file) throws IOException {
        boolean pro = false;
        if (!file.getName().toUpperCase().endsWith("NWK") && !file.getName().toUpperCase().endsWith("TXT")) {
            file = new File(file.getAbsolutePath() + ".nwk");
        }
        if (file.getAbsolutePath().toUpperCase().endsWith("NWK")) {
            pro = true;
            this.path = file.getAbsolutePath();
        }
        BufferedWriter bwrite = new BufferedWriter(new FileWriter(file));
        String nodeinfo = "";
        if (pro) {
            nodeinfo = this.ego_person_info;
            nodeinfo = nodeinfo.replaceAll("\n", "_lb_");
            nodeinfo = nodeinfo.replaceAll(";", "_sk_");
            bwrite.write("E;" + this.ego_person + ";" + this.alter + ";" + nodeinfo);
            bwrite.newLine();
            for (NodeHandler nh : this.nhandler) {
                bwrite.write("F;" + nh.getNh_id() + ";" + nh.getErstelldatum());
                bwrite.newLine();
            }
            for (Node n : this.nodes) {
                nodeinfo = n.getNotiz();
                nodeinfo = nodeinfo.replaceAll("\n", "_lb_");
                nodeinfo = nodeinfo.replaceAll(";", "_sk_");
                if (this.field.getNetfield().isANONYM()) {
                    bwrite.write("N;" + n.getID() + ";" + n.getAnonName() + ";" + (n.isMaennlich() ? "m;" : "w;") + n.getAnonAbk() + ";" + nodeinfo);
                } else {
                    bwrite.write("N;" + n.getID() + ";" + n.getName() + ";" + (n.isMaennlich() ? "m;" : "w;") + n.getAnonAbk() + ";" + nodeinfo);
                }
                bwrite.newLine();
            }
            for (Position p : this.positions) {
                bwrite.write("P;" + p.getId_nhandler() + ";" + p.getN().getID() + ";" + p.getPosX() + ";" + p.getPosY() + ";" + p.getKante());
                bwrite.newLine();
            }
            for (Link l : this.links) {
                bwrite.write("L;" + l.getId_nhandler() + ";" + l.getNode_1().getID() + ";" + l.getNode_2().getID());
                bwrite.newLine();
            }
            bwrite.close();
        } else {
            bwrite.write("E;" + this.getEgo_person() + ";" + this.getAlter() + ";" + this.getNodeHandler().getErstelldatum());
            bwrite.newLine();
            for (Position p : this.positions) {
                if (p.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
                if (this.field.getNetfield().isANONYM()) {
                    bwrite.write("N;" + p.getN().getID() + ";" + p.getN().getAnonName() + ";" + p.getKante() + ";" + p.getPosX() + ";" + p.getPosY() + ";");
                } else {
                    bwrite.write("N;" + p.getN().getID() + ";" + p.getN().getName() + ";" + p.getKante() + ";" + p.getPosX() + ";" + p.getPosY() + ";");
                }
                if (p.getN().isMaennlich()) {
                    bwrite.write("m");
                } else {
                    bwrite.write("w");
                }
                bwrite.newLine();
            }
            for (Link l : this.links) {
                if (l.getId_nhandler() != this.getNodeHandler().getNh_id()) continue;
                bwrite.write("L;" + l.getNode_1().getID() + ";" + l.getNode_2().getID());
                bwrite.newLine();
            }
            bwrite.close();
        }
    }

    public void setErstelldatum(String erstelldatum) {
        this.nhandler.get(this.pos).setErstelldatum(erstelldatum);
    }

    public Position getPositionByNodeInField(int node_id, int field_id) {
        for (Position p : this.positions) {
            if (p.getId_nhandler() != field_id || p.getN().getID() != node_id) continue;
            return p;
        }
        System.out.println("BA3: null - " + node_id + " - " + field_id);
        return null;
    }

    public Position getPositionByNodeInField(int node_id) {
        return this.getPositionByNodeInField(node_id, this.getNodeHandler().getNh_id());
    }

    public int getAlter() {
        return this.alter;
    }

    public void setAlter(int alter) {
        this.alter = alter;
    }

    public String getEgo_person() {
        return this.ego_person;
    }

    public void setEgo_person(String ego_person) {
        this.ego_person = ego_person;
    }

    public List<NodeHandler> getNhandler() {
        return this.nhandler;
    }

    public void setNhandler(List<NodeHandler> nhandler) {
        this.nhandler = nhandler;
    }

    public int getNh_id() {
        return this.nh_id;
    }

    public void setNh_id(int nh_id) {
        this.nh_id = nh_id;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int position) {
        this.pos = position;
    }

    public List<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(List<Position> positions) {
        this.positions = positions;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<AbkKatalog> getAbkkat() {
        return this.abkkat;
    }

    public void setAbkkat(List<AbkKatalog> abkkat) {
        this.abkkat = abkkat;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getEgo_person_info() {
        return this.ego_person_info;
    }

    public void setEgo_person_info(String ego_person_info) {
        this.ego_person_info = ego_person_info;
    }

    public void loadAbkKat() {
        this.abkkat.clear();
        AbkKatalog k = new AbkKatalog(this.getTranslation("shortcutUnknown.short"), this.getTranslation("shortcutUnknown"), "U");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutFamily.short"), this.getTranslation("shortcutFamily"), "Fa");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutFriends.short"), this.getTranslation("shortcutFriends"), "Fr");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutCollegs.short"), this.getTranslation("shortcutCollegs"), "Ko");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutAssistent.short"), this.getTranslation("shortcutAssistent"), "He");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutMarriagePartner.short"), this.getTranslation("shortcutMarriagePartner"), "Pr");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutLifePartner.short"), this.getTranslation("shortcutLifePartner"), "LGf");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutMother.short"), this.getTranslation("shortcutMother"), "M");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutFather.short"), this.getTranslation("shortcutFather"), "V");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutBrother.short"), this.getTranslation("shortcutBrother"), "Br");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutSister.short"), this.getTranslation("shortcutSister"), "Sr");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutSon.short"), this.getTranslation("shortcutSon"), "S");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutDaughter.short"), this.getTranslation("shortcutDaughter"), "T");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutGrandfather.short"), this.getTranslation("shortcutGrandfather"), "GrV");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutGrandmother.short"), this.getTranslation("shortcutGrandmother"), "GrM");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutAffinity.short"), this.getTranslation("shortcutAffinity"), "Sw");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutDaughterInLaw.short"), this.getTranslation("shortcutDaughterInLaw"), "SwT");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutSonInLaw.short"), this.getTranslation("shortcutSonInLaw"), "SwS");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutAunt.short"), this.getTranslation("shortcutAunt"), "Ta");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutAuntByMarriage.short"), this.getTranslation("shortcutAuntByMarriage"), "aTa");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutUncle.short"), this.getTranslation("shortcutUncle"), "On");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutUncleByMarriage.short"), this.getTranslation("shortcutUncleByMarriage"), "aOn");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutNephew.short"), this.getTranslation("shortcutNephew"), "Ne");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutNiece.short"), this.getTranslation("shortcutNiece"), "Ni");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutCousin.short"), this.getTranslation("shortcutCousin"), "Ku");
        this.abkkat.add(k);
        k = new AbkKatalog(this.getTranslation("shortcutNeighbor.short"), this.getTranslation("shortcutNeighbor"), "Nb");
        this.abkkat.add(k);
    }

    private String getTranslation(String id) {
        return this.field.getNetfield().getTranslation(id);
    }
}

