/*
 * Decompiled with CFR 0.152.
 */
package nodehandler;

import java.awt.Graphics;
import netzwerkkarte.NodeMetaHandler;
import nodehandler.Node;
import nodehandler.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Link
implements Comparable<Link> {
    private Position pos_1 = null;
    private Position pos_2 = null;
    private int id_nhandler;

    public Link(int id_nhandler, Position pos_1, Position pos_2) {
        this.id_nhandler = id_nhandler;
        if (pos_1.getN().getID() < pos_2.getN().getID()) {
            this.pos_1 = pos_1;
            this.pos_2 = pos_2;
        } else {
            this.pos_1 = pos_2;
            this.pos_2 = pos_1;
        }
    }

    public void draw(Graphics g, int width, int height) {
        g.drawLine((int)(this.pos_1.getPosX() * (double)width), (int)(this.pos_1.getPosY() * (double)height), (int)(this.pos_2.getPosX() * (double)width), (int)(this.pos_2.getPosY() * (double)height));
    }

    public void drawOnLabel(Graphics g, int centerX, int centerY) {
        NodeMetaHandler nmhandler = Position.getNmhandler();
        int fwidth = nmhandler.getField().getWidth();
        int fheight = nmhandler.getField().getHeight();
        int nX1 = (int)(this.pos_1.getPosX() * (double)fwidth - (double)(fwidth / 2));
        int nY1 = (int)(this.pos_1.getPosY() * (double)fheight - (double)(fheight / 2));
        int nX2 = (int)(this.pos_2.getPosX() * (double)fwidth - (double)(fwidth / 2));
        int nY2 = (int)(this.pos_2.getPosY() * (double)fheight - (double)(fheight / 2));
        g.drawLine(centerX + nX1, centerY + nY1, centerX + nX2, centerY + nY2);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link link = (Link)obj;
            return !(link.pos_1 != this.pos_1 && link.pos_1 != this.pos_2 || link.pos_2 != this.pos_1 && link.pos_2 != this.pos_2);
        }
        return false;
    }

    public int hashCode() {
        return this.pos_1.getN().getID() + this.pos_2.getN().getID();
    }

    public String toString() {
        return this.pos_1.getN().getID() + ": " + this.pos_1.getN().getName() + " - " + this.pos_2.getN().getID() + ": " + this.pos_2.getN().getName();
    }

    @Override
    public int compareTo(Link o) {
        if (this.pos_1.getN().getID() < o.pos_1.getN().getID()) {
            return -1;
        }
        if (this.pos_1.getN().getID() > o.pos_1.getN().getID()) {
            return 1;
        }
        if (this.pos_2.getN().getID() < o.pos_2.getN().getID()) {
            return -1;
        }
        if (this.pos_2.getN().getID() > o.pos_2.getN().getID()) {
            return 1;
        }
        return 0;
    }

    public Node getNode_1() {
        return this.pos_1.getN();
    }

    public Node getNode_2() {
        return this.pos_2.getN();
    }

    public int getId_nhandler() {
        return this.id_nhandler;
    }

    public void setId_nhandler(int id_nhandler) {
        this.id_nhandler = id_nhandler;
    }

    public Position getPos_1() {
        return this.pos_1;
    }

    public void setPos_1(Position pos_1) {
        this.pos_1 = pos_1;
    }

    public Position getPos_2() {
        return this.pos_2;
    }

    public void setPos_2(Position pos_2) {
        this.pos_2 = pos_2;
    }
}

