/*
 * Decompiled with CFR 0.152.
 */
package nodehandler;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import nodehandler.Link;
import nodehandler.LinkStar;
import nodehandler.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAnalysis {
    private Collection<Link> links;
    private int network_gesamt = 0;
    private int network_familie = 0;
    private int network_prof_beziehung = 0;
    private int network_beruf = 0;
    private int network_freunde = 0;
    private int network_kreis3 = 0;
    private int network_kreis32 = 0;
    private int network_kreis321 = 0;
    private int naehensumme_familie = 0;
    private int naehensumme_prof_beziehung = 0;
    private int naehensumme_beruf = 0;
    private int naehensumme_freunde = 0;
    private double dichte_gesamt = 0.0;
    private double dichte_kreis3 = 0.0;
    private double dichte_kreis32 = 0.0;
    private double dichte_kreis321 = 0.0;
    private double dichte_familie = 0.0;
    private double dichte_prof_beziehung = 0.0;
    private double dichte_beruf = 0.0;
    private double dichte_freunde = 0.0;
    private LinkedList<Position> zentralpersons_list = new LinkedList();
    private int person_without_links = 0;
    private int bruecken_num = 0;
    private int bruecken_num_personen = 0;
    private int person_edge_zero = 0;
    private int male = 0;
    private int female = 0;
    private List<Position> pos;

    public NetworkAnalysis() {
        this.pos = null;
        this.links = null;
    }

    public NetworkAnalysis(List<Position> pos, Collection<Link> links, int id_feld) {
        this.pos = new LinkedList<Position>();
        this.links = new HashSet<Link>();
        for (Position n : pos) {
            if (n.getId_nhandler() != id_feld) continue;
            if (n.getKante() == 0) {
                ++this.person_edge_zero;
                continue;
            }
            this.pos.add(n);
        }
        for (Link l : links) {
            if (l.getId_nhandler() != id_feld || l.getPos_1().getKante() == 0 || l.getPos_2().getKante() == 0) continue;
            this.links.add(l);
        }
    }

    public void analyse() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double i = 0.0;
        for (Position n : this.pos) {
            if (n.getKante() == 2) {
                // empty if block
            }
            ++this.network_gesamt;
            if (n.getDistanz() > 6) {
                ++this.network_kreis3;
            }
            if (n.getDistanz() > 3) {
                ++this.network_kreis32;
            }
            ++this.network_kreis321;
            if (n.getN().isMaennlich()) {
                ++this.male;
            } else {
                ++this.female;
            }
            if (n.getPosX() >= 0.5) {
                if (n.getPosY() <= 0.5) {
                    ++this.network_familie;
                    this.naehensumme_familie += n.getDistanz();
                    continue;
                }
                ++this.network_prof_beziehung;
                this.naehensumme_prof_beziehung += n.getDistanz();
                continue;
            }
            if (n.getPosY() >= 0.5) {
                ++this.network_beruf;
                this.naehensumme_beruf += n.getDistanz();
                continue;
            }
            ++this.network_freunde;
            this.naehensumme_freunde += n.getDistanz();
        }
        i = (double)this.pos.size() * ((double)this.pos.size() - 1.0) / 2.0;
        if (d7 > 0.0) {
            this.dichte_kreis321 = this.dichte_gesamt = (double)this.links.size() / i;
        }
        i = (double)this.network_kreis3 * ((double)this.network_kreis3 - 1.0) / 2.0;
        if (d6 > 0.0) {
            this.dichte_kreis3 = (double)this.countLinksWithDist(7, 9) / i;
        }
        i = (double)this.network_kreis32 * ((double)this.network_kreis32 - 1.0) / 2.0;
        if (d5 > 0.0) {
            this.dichte_kreis32 = (double)this.countLinksWithDist(4, 9) / i;
        }
        i = (double)this.network_familie * ((double)this.network_familie - 1.0) / 2.0;
        if (d4 > 0.0) {
            this.dichte_familie = (double)this.countLinksinSector(1) / i;
        }
        i = (double)this.network_prof_beziehung * ((double)this.network_prof_beziehung - 1.0) / 2.0;
        if (d3 > 0.0) {
            this.dichte_prof_beziehung = (double)this.countLinksinSector(2) / i;
        }
        i = (double)this.network_beruf * ((double)this.network_beruf - 1.0) / 2.0;
        if (d2 > 0.0) {
            this.dichte_beruf = (double)this.countLinksinSector(3) / i;
        }
        i = (double)this.network_freunde * ((double)this.network_freunde - 1.0) / 2.0;
        if (d > 0.0) {
            this.dichte_freunde = (double)this.countLinksinSector(4) / i;
        }
        if (this.pos.size() != 0 && this.links.size() != 0) {
            LinkStar[] star = new LinkStar[this.pos.size()];
            LinkStar zentralPerson = new LinkStar(this.pos.get(0));
            LinkedList<LinkStar> zentPer_list = new LinkedList<LinkStar>();
            int j = 0;
            for (Position p : this.pos) {
                star[j] = new LinkStar(p);
                if (p.getPosX() >= 0.5) {
                    if (p.getPosY() <= 0.5) {
                        star[j].setSektor(1);
                    } else {
                        star[j].setSektor(2);
                    }
                } else if (p.getPosY() >= 0.5) {
                    star[j].setSektor(3);
                } else {
                    star[j].setSektor(4);
                }
                ++j;
            }
            LinkStar l1 = null;
            LinkStar l2 = null;
            for (Link l : this.links) {
                for (LinkStar ls : star) {
                    if (ls.getP().getN().getID() == l.getNode_1().getID()) {
                        l1 = ls;
                        ls.count();
                    }
                    if (ls.getP().getN().getID() != l.getNode_2().getID()) continue;
                    l2 = ls;
                    ls.count();
                }
                if (l1.getSektor() == l2.getSektor()) continue;
                l1.setIsBruecke(true);
                l2.setIsBruecke(true);
                ++this.bruecken_num;
            }
            zentralPerson = star[0];
            zentPer_list.add(star[0]);
            for (LinkStar linkstar : star) {
                if (linkstar.getCount() == 0) {
                    ++this.person_without_links;
                }
                if (linkstar.isIsBruecke()) {
                    ++this.bruecken_num_personen;
                }
                if (((LinkStar)zentPer_list.get(0)).getCount() < linkstar.getCount()) {
                    zentPer_list.clear();
                    zentPer_list.add(linkstar);
                    continue;
                }
                if (((LinkStar)zentPer_list.get(0)).getCount() != linkstar.getCount()) continue;
                zentPer_list.add(linkstar);
            }
            this.zentralpersons_list = new LinkedList();
            for (int k = 0; k < zentPer_list.size(); ++k) {
                this.zentralpersons_list.add(((LinkStar)zentPer_list.get(k)).getP());
            }
        }
    }

    private int countLinksinSector(int sector) {
        int count = 0;
        for (Link l : this.links) {
            if (sector == 1 && l.getPos_1().getPosX() >= 0.5 && l.getPos_1().getPosY() <= 0.5 && l.getPos_2().getPosX() >= 0.5 && l.getPos_2().getPosY() <= 0.5) {
                ++count;
            }
            if (sector == 2 && l.getPos_1().getPosX() >= 0.5 && l.getPos_1().getPosY() >= 0.5 && l.getPos_2().getPosX() >= 0.5 && l.getPos_2().getPosY() >= 0.5) {
                ++count;
            }
            if (sector == 3 && l.getPos_1().getPosX() <= 0.5 && l.getPos_1().getPosY() >= 0.5 && l.getPos_2().getPosX() <= 0.5 && l.getPos_2().getPosY() >= 0.5) {
                ++count;
            }
            if (sector != 4 || !(l.getPos_1().getPosX() <= 0.5) || !(l.getPos_1().getPosY() <= 0.5) || !(l.getPos_2().getPosX() <= 0.5) || !(l.getPos_2().getPosY() <= 0.5)) continue;
            ++count;
        }
        return count;
    }

    private int countLinksWithDist(int lower_limit, int upper_limit) {
        int count = 0;
        for (Link l : this.links) {
            if (l.getPos_1().getDistanz() < lower_limit || l.getPos_1().getDistanz() > upper_limit || l.getPos_2().getDistanz() < lower_limit || l.getPos_2().getDistanz() > upper_limit) continue;
            ++count;
        }
        return count;
    }

    public Collection<Link> getLinks() {
        return this.links;
    }

    public void setLinks(Collection<Link> links) {
        this.links = links;
    }

    public List<Position> getPosition() {
        return this.pos;
    }

    public void setPosition(List<Position> pos) {
        this.pos = pos;
    }

    public int getBruecken_num() {
        return this.bruecken_num;
    }

    public int getBruecken_num_personen() {
        return this.bruecken_num_personen;
    }

    public double getDichte_beruf() {
        return this.dichte_beruf;
    }

    public double getDichte_familie() {
        return this.dichte_familie;
    }

    public double getDichte_freunde() {
        return this.dichte_freunde;
    }

    public double getDichte_gesamt() {
        return this.dichte_gesamt;
    }

    public double getDichte_kreis3() {
        return this.dichte_kreis3;
    }

    public double getDichte_kreis32() {
        return this.dichte_kreis32;
    }

    public double getDichte_kreis321() {
        return this.dichte_kreis321;
    }

    public double getDichte_prof_beziehung() {
        return this.dichte_prof_beziehung;
    }

    public int getNaehensumme_beruf() {
        return this.naehensumme_beruf;
    }

    public int getNaehensumme_familie() {
        return this.naehensumme_familie;
    }

    public int getNaehensumme_freunde() {
        return this.naehensumme_freunde;
    }

    public int getNaehensumme_prof_beziehung() {
        return this.naehensumme_prof_beziehung;
    }

    public int getNetwork_beruf() {
        return this.network_beruf;
    }

    public int getNetwork_familie() {
        return this.network_familie;
    }

    public int getNetwork_freunde() {
        return this.network_freunde;
    }

    public int getNetwork_gesamt() {
        return this.network_gesamt;
    }

    public int getNetwork_kreis3() {
        return this.network_kreis3;
    }

    public int getNetwork_kreis32() {
        return this.network_kreis32;
    }

    public int getNetwork_kreis321() {
        return this.network_kreis321;
    }

    public int getNetwork_prof_beziehung() {
        return this.network_prof_beziehung;
    }

    public LinkedList<Position> getzentralpersons_list() {
        return this.zentralpersons_list;
    }

    public int getPerson_without_links() {
        return this.person_without_links;
    }

    public int getFemale() {
        return this.female;
    }

    public void setFemale(int female) {
        this.female = female;
    }

    public int getMale() {
        return this.male;
    }

    public void setMale(int male) {
        this.male = male;
    }

    public int getPerson_edge_zero() {
        return this.person_edge_zero;
    }

    public void setPerson_edge_zeroN(int person_edge_two) {
        this.person_edge_zero = person_edge_two;
    }
}

