/*
 * Decompiled with CFR 0.152.
 */
package nodehandler;

import java.util.LinkedList;
import java.util.List;
import netzwerkkarte.Field;
import nodehandler.NodeDistance;
import nodehandler.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSelectionHandler {
    private Field field;
    private List<NodeDistance> n_dist = null;
    public static final int STATUS_MOVING = 1;
    public static final int STATUS_SELECTED = 2;
    int status = 2;
    private List<Position> pos;

    public NodeSelectionHandler(Field field) {
        this.field = field;
        this.pos = new LinkedList<Position>();
        this.n_dist = new LinkedList<NodeDistance>();
    }

    public NodeSelectionHandler(Position p, Field field) {
        this(field);
        this.pos.add(p);
        p.setSelected(true);
        field.repaint();
    }

    public void selectNode(Position p, boolean select) {
        if (select) {
            this.pos.add(p);
            p.setSelected(select);
        } else {
            this.pos.remove(p);
            p.setSelected(select);
        }
    }

    public void linkAllNodes() {
        for (Position p : this.pos) {
            for (Position m : this.pos) {
                if (p.getN().getID() == m.getN().getID()) continue;
                this.field.getNodeMetaHandler().newLink(p, m);
            }
        }
        this.field.repaint();
    }

    public void deleteAllLinks() {
        for (Position n : this.pos) {
            for (Position m : this.pos) {
                if (n.getN().getID() == m.getN().getID()) continue;
                this.field.getNodeMetaHandler().deleteLink(n, m);
            }
        }
        this.field.repaint();
    }

    public void linkToNode(Position n) {
        for (Position m : this.pos) {
            if (m.getN().getID() == n.getN().getID()) continue;
            this.field.getNodeMetaHandler().newLink(n, m);
        }
    }

    public void deleteLinksToNode(Position n) {
        for (Position m : this.pos) {
            if (m.getN().getID() == n.getN().getID()) continue;
            this.field.getNodeMetaHandler().deleteLink(m, n);
        }
    }

    public int countSelected() {
        return this.pos.size();
    }

    public void removeAll() {
        for (Position n : this.pos) {
            n.setSelected(false);
        }
        this.pos.clear();
    }

    public boolean hasSelectedNodes() {
        return this.pos.size() != 0;
    }

    public boolean isSelected(Position n) {
        for (Position m : this.pos) {
            if (m.getN().getID() != n.getN().getID()) continue;
            return true;
        }
        return false;
    }

    public void moveSelected(double posX, double posY) {
        if (!this.hasSelectedNodes()) {
            return;
        }
        if (this.status == 2) {
            this.n_dist.clear();
            for (Position n : this.pos) {
                this.n_dist.add(new NodeDistance(n, posX - n.getPosX(), posY - n.getPosY()));
            }
            this.status = 1;
            return;
        }
        if (this.status == 1) {
            int i = 0;
            for (Position n : this.pos) {
                n.setPosX(posX - this.n_dist.get(i).getDistX());
                n.setPosY(posY - this.n_dist.get(i).getDistY());
                ++i;
            }
            this.field.repaint();
        }
    }

    public void selectInRect(double posX1, double posY1, double posX2, double posY2) {
        double distX = 0.0;
        double distY = 0.0;
        boolean isInList = false;
        if (posX1 < 0.0 || posX2 < 0.0 || posY1 < 0.0 || posY2 < 0.0) {
            return;
        }
        if (posX1 > posX2) {
            distX = posX1;
            posX1 = posX2;
            posX2 = distX;
        }
        if (posY1 > posY2) {
            distY = posY1;
            posY1 = posY2;
            posY2 = distY;
        }
        distX = posX2 - posX1;
        distY = posY2 - posY1;
        if (distX < 0.01 && distY < 0.01) {
            return;
        }
        for (Position n : this.field.getNodeMetaHandler().getPositions()) {
            double x = n.getPosX() - posX1;
            double y = n.getPosY() - posY1;
            if (n.getId_nhandler() != this.field.getNodeMetaHandler().getNodeHandler().getNh_id() || !(x >= 0.0) || !(y >= 0.0) || !(x <= distX) || !(y <= distY)) continue;
            int i = 0;
            isInList = false;
            for (Position m : this.pos) {
                if (n.getN().getID() == m.getN().getID()) {
                    isInList = true;
                    this.pos.remove(i);
                    n.setSelected(false);
                    break;
                }
                ++i;
            }
            if (isInList) continue;
            this.pos.add(n);
            n.setSelected(true);
        }
    }

    public void deleteNodes() {
        for (Position posi : this.pos) {
            this.field.getNodeMetaHandler().remove(posi.getN().getID(), posi.getId_nhandler());
        }
        this.pos.clear();
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public List<Position> getPositions() {
        return this.pos;
    }

    public void setPositions(List<Position> pos) {
        this.pos = pos;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        if (status == 2) {
            for (Position n : this.pos) {
                n.calcDistance();
            }
        }
    }
}

