/*
 * Decompiled with CFR 0.152.
 */
package language;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import language.Language;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageHandler {
    String currentLanguage;
    LinkedList<Language> languages = new LinkedList();

    public void addLanguage(InputStream inputStream) {
        this.initLanguage(inputStream);
    }

    public String getTranslation(String ID) {
        for (Language l : this.languages) {
            if (!l.getLanguagename().equals(this.currentLanguage)) continue;
            return l.getTranslations().getOrDefault(ID, ID);
        }
        return ID;
    }

    public String getTranslation(String languageShort, String ID) {
        for (Language l : this.languages) {
            if (!l.getShortname().equals(languageShort)) continue;
            return l.getTranslations().getOrDefault(ID, ID);
        }
        return ID;
    }

    private void initLanguage(InputStream inputStream) {
        Language lang = new Language();
        try {
            Document doc = Jsoup.parse(inputStream, "UTF-8", "http://example.com");
            lang.setShortname(doc.getElementById("short").text());
            lang.setLanguagename(doc.getElementById("languageName").text());
            lang.setLanguageNameInEnglish(doc.getElementById("languageNameEnglish").text());
            Elements translations = doc.getElementsByTag("translationselement");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (Element e : translations) {
                map.put(e.id(), e.getElementsByTag("translation").text());
            }
            lang.setTranslations(map);
            this.languages.add(lang);
            this.currentLanguage = lang.getLanguagename();
        }
        catch (Exception ex) {
            System.out.println("Exception has been thrown!");
            ex.printStackTrace();
        }
    }

    public void setCurrentLanguage(String languageName) {
        for (Language l : this.languages) {
            if (l.getShortname().equals(languageName)) {
                this.currentLanguage = l.getLanguagename();
                return;
            }
            if (!l.getLanguagename().equals(languageName)) continue;
            this.currentLanguage = l.getLanguagename();
            return;
        }
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String getCurrentLanguageID() {
        for (Language l : this.languages) {
            if (!l.getLanguagename().equals(this.currentLanguage)) continue;
            return l.getShortname();
        }
        return "Unexpected";
    }

    public LinkedList<Language> getLanguages() {
        return this.languages;
    }
}

