/*
 * Decompiled with CFR 0.152.
 */
package netzwerkkarte;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import netzwerkkarte.Field;
import nodehandler.Link;
import nodehandler.Node;
import nodehandler.Position;

public class SVGExport {
    private Field field;

    public SVGExport(Field field) {
        this.field = field;
    }

    public void store(String path, int width, int height) throws IOException {
        if (!path.toUpperCase().endsWith(".SVG")) {
            path = path + ".svg";
        }
        BufferedWriter bwrite = new BufferedWriter(new FileWriter(path));
        bwrite.write("<?xml version=\"1.0\"?>");
        bwrite.newLine();
        bwrite.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\"");
        bwrite.newLine();
        bwrite.write("  \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write("<svg version=\"1.1\"");
        bwrite.newLine();
        bwrite.write("     xmlns=\"http://www.w3.org/2000/svg\"");
        bwrite.newLine();
        bwrite.write("     xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        bwrite.newLine();
        bwrite.write("<rect x=\"0\" y=\"0\" width=\"" + width + "\" height=\"" + height + "\" fill=\"rgb(239, 239, 239)\" />");
        bwrite.newLine();
        bwrite.write("<circle cx=\"" + width / 2 + "\" cy=\"" + height / 2 + "\" r=\"" + width / 2 + "\" fill=\"rgb(120, 254, 119)\"/>");
        bwrite.newLine();
        bwrite.write("<circle cx=\"" + width / 2 + "\" cy=\"" + height / 2 + "\" r=\"" + width / 3 + "\" fill=\"rgb(255, 255, 255)\"/>");
        bwrite.newLine();
        bwrite.write("<circle cx=\"" + width / 2 + "\" cy=\"" + height / 2 + "\" r=\"" + width / 6 + "\" fill=\"rgb(120, 254, 119)\"/>");
        bwrite.newLine();
        bwrite.write("<line x1=\"" + height / 2 + "\" y1=\"0\" x2=\"" + height / 2 + "\" y2=\"" + width + "\" stroke=\"black\" />");
        bwrite.newLine();
        bwrite.write("<line x1=\"0\" y1=\"" + width / 2 + "\" x2=\"" + height + "\" y2=\"" + width / 2 + "\" stroke=\"black\" />");
        bwrite.newLine();
        bwrite.write("<text x=\"10\" y=\"30\" style=\"font-family:Arial;font-size:28px\">" + this.field.getNetfield().getTranslation("fieldNameUpLeft") + "</text>");
        bwrite.newLine();
        bwrite.write("<text x=\"" + (width - 100) + "\" y=\"30\" style=\"font-family:Arial;font-size:28px\">" + this.field.getNetfield().getTranslation("fieldNameUpRight") + "</text>");
        bwrite.newLine();
        bwrite.write("<text x=\"10\" y=\"" + (height - 30) + "\" style=\"font-family:Arial;font-size:28px\">" + this.field.getNetfield().getTranslation("fieldNameDownLeft") + "</text>");
        bwrite.newLine();
        bwrite.newLine();
        bwrite.write("<text x=\"" + (width - 220) + "\" y=\"" + (height - 30) + "\" style=\"font-family:Arial;font-size:28px\">" + this.field.getNetfield().getTranslation("fieldNameDownRight") + "</text>");
        bwrite.newLine();
        if (this.field.getNodeMetaHandler().getEgo_person() != null && !this.field.getNodeMetaHandler().getEgo_person().equals("")) {
            bwrite.write("<text x=\"" + (int)(0.52 * (double)width) + "\" y=\"20\" style=\"font-family:Arial;font-size:16px\">" + this.field.getNetfield().getTranslation("fieldNetworkFrom") + "</text>");
            bwrite.newLine();
            bwrite.write("<text x=\"" + (int)(0.52 * (double)width) + "\" y=\"40\" " + "style=\"font-family:Arial;font-size:16px\">" + this.field.getNodeMetaHandler().getEgo_person() + " (" + this.field.getNodeMetaHandler().getAlter() + "a), " + this.field.getNodeHandler().getErstelldatum() + "</text>");
            bwrite.newLine();
        }
        bwrite.newLine();
        String nodeinfo = "";
        for (Position p : this.field.getNodeMetaHandler().getPositions()) {
            if (p.getId_nhandler() != this.field.getNodeMetaHandler().getNodeHandler().getNh_id() || p.getKante() == 0) continue;
            nodeinfo = "<line x1=\"" + (int)(p.getPosX() * (double)width) + "\" y1=\"" + (int)(p.getPosY() * (double)height) + "\" x2=\"" + width / 2 + "\" y2=\"" + height / 2;
            if (p.getKante() == 1) {
                nodeinfo = nodeinfo + "\" stroke=\"black\" />";
            } else if (p.getKante() == 2) {
                nodeinfo = nodeinfo + "\" stroke=\"red\" />";
            }
            bwrite.write(nodeinfo);
            bwrite.newLine();
        }
        bwrite.newLine();
        for (Link l : this.field.getNodeMetaHandler().getLinks()) {
            if (l.getId_nhandler() != this.field.getNodeMetaHandler().getNodeHandler().getNh_id()) continue;
            nodeinfo = "<line x1=\"" + (int)(l.getPos_1().getPosX() * (double)width) + "\" y1=\"" + (int)(l.getPos_1().getPosY() * (double)height) + "\" x2=\"" + (int)(l.getPos_2().getPosX() * (double)width) + "\" y2=\"" + (int)(l.getPos_2().getPosY() * (double)height) + "\" stroke=\"black\" />";
            bwrite.write(nodeinfo);
            bwrite.newLine();
            bwrite.newLine();
        }
        for (Position p : this.field.getNodeMetaHandler().getPositions()) {
            if (p.getId_nhandler() != this.field.getNodeMetaHandler().getNodeHandler().getNh_id()) continue;
            nodeinfo = p.getN().isWeiblich() ? "<circle cx=\"" + (int)(p.getPosX() * (double)width) + "\" cy=\"" + (int)(p.getPosY() * (double)height) + "\" r=\"" + Node.getRadius() + "\" fill=\"#808080\" />" : "<rect x=\"" + (int)(p.getPosX() * (double)width - (double)Node.getRadius()) + "\" y=\"" + (int)(p.getPosY() * (double)height - (double)Node.getRadius()) + "\" width=\"" + Node.getRadius() * 2 + "\" height=\"" + Node.getRadius() * 2 + "\" fill=\"#808080\" />";
            bwrite.write(nodeinfo);
            bwrite.newLine();
            nodeinfo = "<text x=\"" + (int)(p.getPosX() * (double)width + (double)Node.radius) + "\" y=\"" + (int)(p.getPosY() * (double)height - (double)Node.radius) + "\" style=\"font-family:Arial;font-size:16px\">" + p.getN().getName() + "</text>";
            bwrite.write(nodeinfo);
            bwrite.newLine();
            bwrite.newLine();
        }
        bwrite.write("</svg>");
        bwrite.close();
    }
}

