/*
 * Decompiled with CFR 0.152.
 */
package nodehandler;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import netzwerkkarte.NodeMetaHandler;
import nodehandler.Node;

public class Position {
    private int id_nhandler;
    private Node n;
    private double posX;
    private double posY;
    private int kante;
    private int distanz;
    private boolean selected;
    private static final double KANTE_AREA = 0.05555555555555555;
    private static NodeMetaHandler nmhandler;

    public Position(NodeMetaHandler parent, int id_nhandler, Node n, double posX, double posY, int kante) {
        nmhandler = parent;
        this.id_nhandler = id_nhandler;
        this.n = n;
        this.posX = posX;
        this.posY = posY;
        this.kante = kante;
        this.calcDistance();
    }

    public void calcDistance() {
        double dis_zentrumX = this.posX - 0.5;
        double dis_zentrumY = this.posY - 0.5;
        double dis = Math.hypot(dis_zentrumX, dis_zentrumY);
        this.distanz = 9 - (int)(dis /= 0.05555555555555555);
        if (this.distanz <= 0) {
            this.kante = 0;
        }
    }

    public void draw(Graphics g, int width, int height) {
        this.drawLine(g, width, height);
        this.drawCircle(g, width, height);
    }

    public void drawMouse(Graphics g, int mouse_posX, int mouse_posY) {
        Color c = g.getColor();
        int radius = Node.getRadius();
        if (this.selected) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.GRAY);
        }
        if (this.n.isWeiblich()) {
            g.fillOval(mouse_posX - radius, mouse_posY - radius, radius * 2, radius * 2);
        } else {
            g.fillRect(mouse_posX - radius, mouse_posY - radius, radius * 2, radius * 2);
        }
        g.setColor(c);
        g.setFont(new Font("Dialog", 1, 12));
        g.drawString(this.n.getName(), mouse_posX + Node.getRadius(), mouse_posY - Node.getRadius());
    }

    public void drawLine(Graphics g, int width, int height) {
        Color c = g.getColor();
        if (this.kante == 1) {
            g.drawLine((int)(this.posX * (double)width), (int)(this.posY * (double)height), width / 2, height / 2);
        }
        if (this.kante == 2) {
            c = g.getColor();
            g.setColor(Color.RED);
            g.drawLine((int)(this.posX * (double)width), (int)(this.posY * (double)height), width / 2, height / 2);
            g.setColor(c);
        }
    }

    public void drawCircle(Graphics g, int width, int height) {
        Color c = g.getColor();
        int radius = Node.getRadius();
        if (this.selected) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.GRAY);
        }
        if (this.n.isWeiblich()) {
            g.fillOval((int)(this.posX * (double)width - (double)radius), (int)(this.posY * (double)height - (double)radius), radius * 2, radius * 2);
        } else {
            g.fillRect((int)(this.posX * (double)width - (double)radius), (int)(this.posY * (double)height - (double)radius), radius * 2, radius * 2);
        }
        g.setColor(c);
    }

    public void drawCircleOnLabel(Graphics g, int width, int height, int centerX, int centerY) {
        Color c = g.getColor();
        Position position = this;
        int radius = position.n.getRadius();
        int fwidth = nmhandler.getField().getWidth();
        int fheight = nmhandler.getField().getHeight();
        int nX = (int)(this.posX * (double)fwidth - (double)(fwidth / 2));
        int nY = (int)(this.posY * (double)fheight - (double)(fheight / 2));
        if (this.selected) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.GRAY);
        }
        if (this.n.isWeiblich()) {
            g.fillOval(centerX + nX - radius, centerY + nY - radius, radius * 2, radius * 2);
        } else {
            g.fillRect(centerX + nX - radius, centerY + nY - radius, radius * 2, radius * 2);
        }
        g.setColor(c);
    }

    public void drawString(Graphics g, int width, int height, boolean anonym) {
        g.setFont(new Font("Dialog", 1, 12));
        if (anonym) {
            g.drawString(this.n.getAnonName(), (int)(this.posX * (double)width) + Node.getRadius(), (int)(this.posY * (double)height) - Node.getRadius());
        } else {
            g.drawString(this.n.getName() + "/" + this.n.getAnonAbk(), (int)(this.posX * (double)width) + Node.getRadius(), (int)(this.posY * (double)height) - Node.getRadius());
        }
    }

    public void drawStringOnLabel(Graphics g, int width, int height, boolean anonym, int centerX, int centerY) {
        g.setFont(new Font("Dialog", 1, 12));
        int fwidth = nmhandler.getField().getWidth();
        int fheight = nmhandler.getField().getHeight();
        int nX = (int)(this.posX * (double)fwidth - (double)(fwidth / 2));
        int nY = (int)(this.posY * (double)fheight - (double)(fheight / 2));
        if (anonym) {
            g.drawString(this.n.getAnonName(), centerX + nX + Node.getRadius(), centerY + nY - Node.getRadius());
        } else {
            g.drawString(this.n.getName(), centerX + nX + Node.getRadius(), centerY + nY - Node.getRadius());
        }
    }

    public void drawLineOnLabel(Graphics g, int width, int height, int centerX, int centerY) {
        Color c = g.getColor();
        int fwidth = nmhandler.getField().getWidth();
        int fheight = nmhandler.getField().getHeight();
        int nX = (int)(this.posX * (double)fwidth - (double)(fwidth / 2));
        int nY = (int)(this.posY * (double)fheight - (double)(fheight / 2));
        if (this.kante == 1) {
            g.drawLine(centerX + nX, centerY + nY, centerX, centerY);
        }
        if (this.kante == 2) {
            g.setColor(Color.RED);
            g.drawLine(centerX + nX, centerY + nY, centerX, centerY);
            g.setColor(c);
        }
    }

    public int getId_nhandler() {
        return this.id_nhandler;
    }

    public void setId_nhandler(int id_nhandler) {
        this.id_nhandler = id_nhandler;
    }

    public int getKante() {
        return this.kante;
    }

    public void setKante(int kante) {
        this.kante = kante;
    }

    public double getPosX() {
        return this.posX;
    }

    public void setPosX(double posX) {
        this.posX = posX;
    }

    public double getPosY() {
        return this.posY;
    }

    public void setPosY(double posY) {
        this.posY = posY;
    }

    public int getDistanz() {
        return this.distanz;
    }

    public Node getN() {
        return this.n;
    }

    public void setN(Node n) {
        this.n = n;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public static NodeMetaHandler getNmhandler() {
        return nmhandler;
    }

    public static void setNmhandler(NodeMetaHandler nmhandler) {
        Position.nmhandler = nmhandler;
    }
}

